/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.switchyard.exchange;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.overlord.rtgov.activity.collector.ActivityCollector;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.soa.RPCActivityType;
import org.overlord.rtgov.activity.model.soa.RequestReceived;
import org.overlord.rtgov.activity.model.soa.RequestSent;
import org.overlord.rtgov.activity.model.soa.ResponseReceived;
import org.overlord.rtgov.activity.model.soa.ResponseSent;
import org.switchyard.ExchangePhase;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.Service;
import org.switchyard.ServiceReference;
import org.switchyard.bus.camel.CamelCompositeContext;
import org.switchyard.bus.camel.CamelMessage;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.extensions.wsdl.WSDLService;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.security.SecurityContext;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.NameCredential;
import org.switchyard.security.credential.PrincipalCredential;

public class AbstractExchangeValidator {
    private static final Logger LOG = Logger.getLogger(AbstractExchangeValidator.class.getName());
    private static final String ACTIVITY_COLLECTOR = "java:global/overlord-rtgov/ActivityCollector";
    @Resource(lookup="java:global/overlord-rtgov/ActivityCollector")
    private ActivityCollector _activityCollector = null;
    private boolean _initialized = false;

    @PostConstruct
    protected void init() {
        if (this._activityCollector == null) {
            try {
                InitialContext ctx = new InitialContext();
                this._activityCollector = (ActivityCollector)ctx.lookup(ACTIVITY_COLLECTOR);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to initialize activity collector", e);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("*********** Exchange Interceptor Initialized with collector=" + this._activityCollector);
        }
        this._initialized = true;
    }

    protected void handleExchange(Exchange exch, ExchangePhase phase) {
        CamelMessage mesg;
        if (!this._initialized) {
            this.init();
        }
        if ((mesg = (CamelMessage)exch.getIn()) == null) {
            LOG.severe("Could not obtain message for phase (" + phase + ") and exchange: " + exch);
            return;
        }
        CamelCompositeContext context = new CamelCompositeContext(exch, (Message)mesg);
        Service provider = (Service)exch.getProperty("org.switchyard.bus.camel.provider", Service.class);
        ServiceReference consumer = (ServiceReference)exch.getProperty("org.switchyard.bus.camel.consumer", ServiceReference.class);
        SecurityContext securityContext = (SecurityContext)exch.getProperty("org.switchyard.bus.camel.securityContext", SecurityContext.class);
        BaseExchangeContract contract = (BaseExchangeContract)exch.getProperty("org.switchyard.bus.camel.contract", BaseExchangeContract.class);
        if (provider == null && LOG.isLoggable(Level.FINEST)) {
            LOG.finest("No provider specified - probably an exception: " + mesg.getContent());
        }
        if (this._activityCollector != null) {
            String messageId = null;
            String relatesTo = null;
            String contentType = null;
            Set props = context.getProperties(Scope.MESSAGE);
            for (Property p : props) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Switchyard property: name=" + p.getName() + " value=" + p.getValue());
                }
                if (p.getName().equals("org.switchyard.messageId")) {
                    messageId = (String)p.getValue();
                    continue;
                }
                if (p.getName().equals("org.switchyard.relatesTo")) {
                    relatesTo = (String)p.getValue();
                    continue;
                }
                if (!p.getName().equals("org.switchyard.contentType")) continue;
                contentType = ((QName)p.getValue()).toString();
            }
            QName serviceType = consumer.getName();
            String opName = contract.getConsumerOperation().getName();
            if (phase == ExchangePhase.IN) {
                if (!consumer.getConsumerMetadata().isBinding()) {
                    RequestSent sent = new RequestSent();
                    if (provider == null || !provider.getProviderMetadata().isBinding()) {
                        sent.setServiceType(serviceType.toString());
                    }
                    sent.setInterface(this.getInterface(consumer, provider));
                    sent.setOperation(opName);
                    sent.setMessageId(messageId);
                    this.validate((org.switchyard.Message)mesg, contentType, (RPCActivityType)sent, securityContext);
                }
                if (provider == null || !provider.getProviderMetadata().isBinding()) {
                    RequestReceived recvd = new RequestReceived();
                    recvd.setServiceType(serviceType.toString());
                    recvd.setInterface(this.getInterface(consumer, provider));
                    recvd.setOperation(opName);
                    recvd.setMessageId(messageId);
                    this.validate((org.switchyard.Message)mesg, contentType, (RPCActivityType)recvd, securityContext);
                }
            } else if (phase == ExchangePhase.OUT) {
                if (contentType == null) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("No content type - possibly due to exception on handling the request");
                    }
                    return;
                }
                if (provider == null || !provider.getProviderMetadata().isBinding()) {
                    ResponseSent sent = new ResponseSent();
                    if (provider == null || !provider.getProviderMetadata().isBinding()) {
                        sent.setServiceType(serviceType.toString());
                    }
                    sent.setInterface(this.getInterface(consumer, provider));
                    sent.setOperation(opName);
                    sent.setMessageId(messageId);
                    sent.setReplyToId(relatesTo);
                    this.validate((org.switchyard.Message)mesg, contentType, (RPCActivityType)sent, securityContext);
                }
                if (!consumer.getConsumerMetadata().isBinding()) {
                    ResponseReceived recvd = new ResponseReceived();
                    recvd.setServiceType(serviceType.toString());
                    recvd.setInterface(this.getInterface(consumer, provider));
                    recvd.setOperation(opName);
                    recvd.setMessageId(messageId);
                    recvd.setReplyToId(relatesTo);
                    this.validate((org.switchyard.Message)mesg, contentType, (RPCActivityType)recvd, securityContext);
                }
            }
        }
    }

    protected String getInterface(ServiceReference consumer, Service provider) {
        String ret = null;
        ServiceInterface intf = null;
        intf = consumer.getConsumerMetadata().isBinding() ? consumer.getInterface() : provider.getInterface();
        if ("java".equals(intf.getType())) {
            ret = ((JavaService)intf).getJavaInterface().getName();
        } else if ("wsdl".equals(intf.getType())) {
            ret = ((WSDLService)intf).getPortType().toString();
        }
        return ret;
    }

    protected void validate(org.switchyard.Message msg, String contentType, RPCActivityType at, SecurityContext sc) {
        if (at != null) {
            at.setMessageType(contentType);
            Object content = msg.getContent();
            at.setContent(this._activityCollector.processInformation(null, contentType, content, null, (ActivityType)at));
            if (sc != null) {
                for (Credential cred : sc.getCredentials()) {
                    if (cred instanceof NameCredential) {
                        at.setPrincipal(((NameCredential)cred).getName());
                        break;
                    }
                    if (!(cred instanceof PrincipalCredential)) continue;
                    at.setPrincipal(((PrincipalCredential)cred).getPrincipal().getName());
                    break;
                }
            }
            try {
                this._activityCollector.validate((ActivityType)at);
            }
            catch (Exception e) {
                throw new SwitchYardException(e.getMessage());
            }
        }
    }
}

