/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.internal.switchyard;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.overlord.rtgov.activity.collector.ActivityCollector;
import org.overlord.rtgov.internal.switchyard.EventProcessor;
import org.switchyard.event.EventObserver;

@ApplicationScoped
@Singleton
@Startup
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class EventProcessorManager {
    private static final String SWITCHAYRD_MANAGEMENT_LOCAL = "org.switchyard.admin:type=Management.Local";
    private static final Logger LOG = Logger.getLogger(EventProcessorManager.class.getName());
    @Inject
    @Dependent
    private ActivityCollector _activityCollector = null;
    @Inject
    @Any
    @Dependent
    private Instance<EventProcessor> _eventProcessors = null;

    @PostConstruct
    public void init() {
        block6: {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("SwitchYard EventProcessorManager Initialized with collector=" + this._activityCollector);
            }
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objname = null;
            try {
                objname = new ObjectName(SWITCHAYRD_MANAGEMENT_LOCAL);
                for (EventProcessor ep : this._eventProcessors) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("SwitchYard EventProcessorManager register event processor=" + ep);
                    }
                    ep.init(this._activityCollector);
                    ArrayList eventTypes = new ArrayList();
                    eventTypes.add(ep.getEventType());
                    Object[] params = new Object[]{ep, eventTypes};
                    String[] types = new String[]{EventObserver.class.getName(), List.class.getName()};
                    mbs.invoke(objname, "addObserver", params, types);
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block6;
                LOG.log(Level.FINE, "Failed to register SwitchYard event observer via MBean", e);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("SwitchYard EventProcessorManager Initialization Completed");
        }
    }

    @PreDestroy
    public void close() {
        block5: {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objname = null;
            try {
                objname = new ObjectName(SWITCHAYRD_MANAGEMENT_LOCAL);
                for (EventProcessor ep : this._eventProcessors) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("SwitchYard EventProcessorManager unregister event processor=" + ep);
                    }
                    Object[] params = new Object[]{ep};
                    String[] types = new String[]{EventObserver.class.getName()};
                    mbs.invoke(objname, "removeObserver", params, types);
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.log(Level.FINE, "Failed to unregister SwitchYard event observer via MBean", e);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("SwitchYard EventProcessorManager Close Completed");
        }
    }
}

