/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.internal.switchyard.camel;

import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.management.event.AbstractExchangeEvent;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.soa.RPCActivityType;
import org.overlord.rtgov.activity.model.soa.RequestReceived;
import org.overlord.rtgov.activity.model.soa.RequestSent;
import org.overlord.rtgov.activity.model.soa.ResponseReceived;
import org.overlord.rtgov.activity.model.soa.ResponseSent;
import org.overlord.rtgov.internal.switchyard.AbstractEventProcessor;
import org.switchyard.ExchangePhase;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.Service;
import org.switchyard.ServiceReference;
import org.switchyard.bus.camel.CamelCompositeContext;
import org.switchyard.bus.camel.CamelMessage;
import org.switchyard.extensions.java.JavaService;
import org.switchyard.extensions.wsdl.WSDLService;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.Registrant;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.security.SecurityContext;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.NameCredential;
import org.switchyard.security.credential.PrincipalCredential;

public abstract class AbstractExchangeEventProcessor
extends AbstractEventProcessor {
    private static final Logger LOG = Logger.getLogger(AbstractExchangeEventProcessor.class.getName());
    private boolean _completedEvent = false;

    public AbstractExchangeEventProcessor(Class<? extends EventObject> eventType, boolean completed) {
        super(eventType);
        this._completedEvent = completed;
    }

    @Override
    public void handleEvent(EventObject event) {
        Exchange exch = ((AbstractExchangeEvent)event).getExchange();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("********* Exchange=" + exch);
        }
        CamelMessage mesg = (CamelMessage)exch.getIn();
        ExchangePhase phase = (ExchangePhase)exch.getProperty("org.switchyard.bus.camel.phase", ExchangePhase.class);
        if (phase == null) {
            LOG.severe("Could not obtain phase from exchange: " + exch);
            return;
        }
        if (mesg == null) {
            LOG.severe("Could not obtain message for phase (" + phase + ") and exchange: " + exch);
            return;
        }
        CamelCompositeContext context = new CamelCompositeContext(exch, (Message)mesg);
        Service provider = (Service)exch.getProperty("org.switchyard.bus.camel.provider", Service.class);
        ServiceReference consumer = (ServiceReference)exch.getProperty("org.switchyard.bus.camel.consumer", ServiceReference.class);
        String messageId = null;
        Property mip = context.getProperty("org.switchyard.messageId", Scope.MESSAGE);
        if (mip != null) {
            messageId = (String)mip.getValue();
        }
        String contentType = null;
        Property ctp = context.getProperty("org.switchyard.contentType", Scope.MESSAGE);
        if (ctp != null) {
            contentType = ((QName)ctp.getValue()).toString();
        }
        if (phase == ExchangePhase.IN) {
            this.handleInExchange(exch, provider, consumer, messageId, contentType, mesg);
        } else if (phase == ExchangePhase.OUT) {
            if (contentType == null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("No content type - possibly due to exception on handling the request");
                }
                return;
            }
            String relatesTo = null;
            Property rtp = context.getProperty("org.switchyard.relatesTo", Scope.MESSAGE);
            if (rtp != null) {
                relatesTo = (String)rtp.getValue();
            }
            this.handleOutExchange(exch, provider, consumer, messageId, relatesTo, contentType, mesg);
        }
    }

    protected void handleInExchange(Exchange exch, Service provider, ServiceReference consumer, String messageId, String contentType, CamelMessage mesg) {
        Registrant consumerReg = consumer.getServiceMetadata().getRegistrant();
        if (this._completedEvent) {
            if (consumerReg.isBinding()) {
                this.getActivityCollector().endScope();
            }
            return;
        }
        Registrant providerReg = provider == null ? null : provider.getServiceMetadata().getRegistrant();
        String intf = this.getInterface(consumer, provider, consumerReg);
        SecurityContext securityContext = (SecurityContext)exch.getProperty("org.switchyard.bus.camel.securityContext", SecurityContext.class);
        BaseExchangeContract contract = (BaseExchangeContract)exch.getProperty("org.switchyard.bus.camel.contract", BaseExchangeContract.class);
        QName serviceType = consumer.getName();
        String opName = contract.getConsumerOperation().getName();
        if (consumerReg.isBinding()) {
            this.getActivityCollector().startScope();
        } else {
            RequestSent sent = new RequestSent();
            if (provider == null || !providerReg.isBinding()) {
                sent.setServiceType(serviceType.toString());
            }
            sent.setInterface(intf);
            sent.setOperation(opName);
            sent.setMessageId(messageId);
            this.record((org.switchyard.Message)mesg, contentType, (RPCActivityType)sent, securityContext, exch);
            if (intf == null) {
                exch.setProperty("rtgov.request.sent", (Object)sent);
            }
        }
        if (provider == null || !providerReg.isBinding()) {
            RequestReceived recvd = new RequestReceived();
            recvd.setServiceType(serviceType.toString());
            recvd.setInterface(intf);
            recvd.setOperation(opName);
            recvd.setMessageId(messageId);
            this.record((org.switchyard.Message)mesg, contentType, (RPCActivityType)recvd, securityContext, exch);
            if (intf == null) {
                exch.setProperty("rtgov.request.received", (Object)recvd);
            }
        }
    }

    protected void handleOutExchange(Exchange exch, Service provider, ServiceReference consumer, String messageId, String relatesTo, String contentType, CamelMessage mesg) {
        Registrant consumerReg = consumer.getServiceMetadata().getRegistrant();
        Registrant providerReg = provider == null ? null : provider.getServiceMetadata().getRegistrant();
        String intf = this.getInterface(consumer, provider, consumerReg);
        SecurityContext securityContext = (SecurityContext)exch.getProperty("org.switchyard.bus.camel.securityContext", SecurityContext.class);
        BaseExchangeContract contract = (BaseExchangeContract)exch.getProperty("org.switchyard.bus.camel.contract", BaseExchangeContract.class);
        QName serviceType = consumer.getName();
        String opName = contract.getConsumerOperation().getName();
        RequestReceived rr = (RequestReceived)exch.getProperty("rtgov.request.received");
        RequestSent rs = (RequestSent)exch.getProperty("rtgov.request.sent");
        if (intf != null) {
            if (rr != null) {
                rr.setInterface(intf);
            }
            if (rs != null) {
                rs.setInterface(intf);
            }
        }
        if (provider == null || !providerReg.isBinding()) {
            ResponseSent sent = new ResponseSent();
            if (provider == null || !providerReg.isBinding()) {
                sent.setServiceType(serviceType.toString());
            }
            sent.setInterface(intf);
            sent.setOperation(opName);
            sent.setMessageId(messageId);
            sent.setReplyToId(relatesTo);
            this.record((org.switchyard.Message)mesg, contentType, (RPCActivityType)sent, securityContext, exch);
        }
        if (consumerReg.isBinding()) {
            this.getActivityCollector().endScope();
        } else {
            ResponseReceived recvd = new ResponseReceived();
            recvd.setServiceType(serviceType.toString());
            recvd.setInterface(intf);
            recvd.setOperation(opName);
            recvd.setMessageId(messageId);
            recvd.setReplyToId(relatesTo);
            this.record((org.switchyard.Message)mesg, contentType, (RPCActivityType)recvd, securityContext, exch);
        }
    }

    protected String getInterface(ServiceReference consumer, Service provider, Registrant consumerReg) {
        String ret = null;
        ServiceInterface intf = null;
        if (consumerReg.isBinding()) {
            intf = consumer.getInterface();
        } else if (provider != null) {
            intf = provider.getInterface();
        }
        if (intf != null) {
            if ("java".equals(intf.getType())) {
                ret = ((JavaService)intf).getJavaInterface().getName();
            } else if ("wsdl".equals(intf.getType())) {
                ret = ((WSDLService)intf).getPortType().toString();
            }
        }
        return ret;
    }

    protected void record(org.switchyard.Message msg, String contentType, RPCActivityType at, SecurityContext sc, Exchange exch) {
        if (at != null) {
            at.setMessageType(contentType);
            Object content = msg.getContent();
            at.setContent(this.getActivityCollector().processInformation(null, contentType, content, null, (ActivityType)at));
            if (sc != null && sc.getCredentials().size() > 0) {
                for (Credential cred : sc.getCredentials()) {
                    if (cred instanceof NameCredential) {
                        at.setPrincipal(((NameCredential)cred).getName());
                        break;
                    }
                    if (!(cred instanceof PrincipalCredential)) continue;
                    at.setPrincipal(((PrincipalCredential)cred).getPrincipal().getName());
                    break;
                }
            }
            this.recordActivity(exch, (ActivityType)at);
        }
    }
}

