/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.internal.switchyard.exchange;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.soa.RPCActivityType;
import org.overlord.rtgov.activity.model.soa.RequestReceived;
import org.overlord.rtgov.activity.model.soa.RequestSent;
import org.overlord.rtgov.activity.model.soa.ResponseReceived;
import org.overlord.rtgov.activity.model.soa.ResponseSent;
import org.overlord.rtgov.internal.switchyard.AbstractEventProcessor;
import org.overlord.rtgov.internal.switchyard.exchange.PropertyAccessor;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.Service;
import org.switchyard.ServiceReference;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.extensions.java.JavaService;
import org.switchyard.extensions.wsdl.WSDLService;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.Registrant;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.context.SecurityContextManager;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.NameCredential;
import org.switchyard.security.credential.PrincipalCredential;

public abstract class AbstractExchangeEventProcessor
extends AbstractEventProcessor {
    private static final String GATEWAY_PROPERTY = "gateway";
    private static final String UNEXPECTED_FAULT = "ERROR";
    private static final String RTGOV_REQUEST_SENT = "rtgov.request.sent";
    private static final String RTGOV_REQUEST_RECEIVED = "rtgov.request.received";
    private static final Logger LOG = Logger.getLogger(AbstractExchangeEventProcessor.class.getName());
    private boolean _completedEvent = false;

    public AbstractExchangeEventProcessor(Class<? extends EventObject> eventType, boolean completed) {
        super(eventType);
        this._completedEvent = completed;
    }

    protected abstract Exchange getExchange(EventObject var1);

    @Override
    public void handleEvent(EventObject event) {
        try {
            Exchange exch = this.getExchange(event);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("********* Exchange=" + exch);
            }
            Message mesg = exch.getMessage();
            ExchangePhase phase = exch.getPhase();
            if (phase == null) {
                LOG.severe("Could not obtain phase from exchange: " + exch);
                return;
            }
            if (mesg == null) {
                LOG.severe("Could not obtain message for phase (" + phase + ") and exchange: " + exch);
                return;
            }
            Context context = exch.getContext();
            Service provider = exch.getProvider();
            ServiceReference consumer = exch.getConsumer();
            String messageId = null;
            Property mip = context.getProperty("org.switchyard.messageId", Scope.MESSAGE);
            if (mip != null) {
                messageId = (String)mip.getValue();
            }
            String contentType = null;
            Property ctp = context.getProperty("org.switchyard.contentType", Scope.MESSAGE);
            if (ctp != null && (contentType = ((QName)ctp.getValue()).toString()) != null && contentType.startsWith("java:")) {
                contentType = contentType.substring(5);
            }
            if (phase == ExchangePhase.IN) {
                this.handleInExchange(exch, provider, consumer, messageId, contentType, mesg);
            } else if (phase == ExchangePhase.OUT) {
                String relatesTo = null;
                Property rtp = context.getProperty("org.switchyard.relatesTo", Scope.MESSAGE);
                if (rtp != null) {
                    relatesTo = (String)rtp.getValue();
                }
                this.handleOutExchange(exch, provider, consumer, messageId, relatesTo, contentType, mesg);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("rtgov-switchyard.Messages").getString("RTGOV-SWITCHYARD-1"), t);
        }
    }

    protected void handleInExchange(Exchange exch, Service provider, ServiceReference consumer, String messageId, String contentType, Message mesg) {
        Property prop;
        BindingModel bm;
        int i;
        List bindings;
        String gatewayName;
        Registrant consumerReg = consumer.getServiceMetadata().getRegistrant();
        if (this._completedEvent) {
            this.handleOutExchange(exch, provider, consumer, messageId + "onewayreturn", messageId, null, null);
            return;
        }
        Registrant providerReg = provider == null ? null : provider.getServiceMetadata().getRegistrant();
        String intf = this.getInterface(consumer, provider, consumerReg);
        SecurityContextManager scm = new SecurityContextManager(exch.getConsumer().getDomain());
        SecurityContext securityContext = scm.getContext(exch);
        ExchangeContract contract = exch.getContract();
        QName serviceType = consumer.getName();
        String opName = contract.getConsumerOperation().getName();
        if (consumerReg.isBinding()) {
            this.getActivityCollector().startScope();
        } else {
            RequestSent sent = new RequestSent();
            if (providerReg == null || !providerReg.isBinding()) {
                sent.setServiceType(serviceType.toString());
            } else if (providerReg.isBinding()) {
                gatewayName = (String)exch.getContext().getPropertyValue("org.switchyard.exchangeGatewayName");
                bindings = (List)providerReg.getConfig();
                for (i = 0; gatewayName != null && i < bindings.size(); ++i) {
                    bm = (BindingModel)bindings.get(i);
                    if (!gatewayName.equals(bm.getName())) continue;
                    sent.getProperties().put(GATEWAY_PROPERTY, bm.getType());
                }
            }
            sent.setInterface(intf);
            sent.setOperation(opName);
            sent.setMessageId(messageId);
            this.record(mesg, contentType, (RPCActivityType)sent, securityContext, exch);
            if (intf == null) {
                prop = exch.getContext().setProperty(RTGOV_REQUEST_SENT, (Object)sent, Scope.EXCHANGE);
                prop.addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
            }
        }
        if (providerReg == null || !providerReg.isBinding()) {
            RequestReceived recvd = new RequestReceived();
            recvd.setServiceType(serviceType.toString());
            recvd.setInterface(intf);
            recvd.setOperation(opName);
            recvd.setMessageId(messageId);
            if (consumerReg.isBinding()) {
                gatewayName = (String)exch.getContext().getPropertyValue("org.switchyard.exchangeGatewayName");
                bindings = (List)consumerReg.getConfig();
                for (i = 0; gatewayName != null && i < bindings.size(); ++i) {
                    bm = (BindingModel)bindings.get(i);
                    if (!gatewayName.equals(bm.getName())) continue;
                    recvd.getProperties().put(GATEWAY_PROPERTY, bm.getType());
                }
            }
            this.record(mesg, contentType, (RPCActivityType)recvd, securityContext, exch);
            prop = exch.getContext().setProperty(RTGOV_REQUEST_RECEIVED, (Object)recvd, Scope.EXCHANGE);
            prop.addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        }
    }

    protected void handleOutExchange(Exchange exch, Service provider, ServiceReference consumer, String messageId, String relatesTo, String contentType, Message mesg) {
        BindingModel bm;
        int i;
        List bindings;
        String gatewayName;
        RequestSent rs;
        Registrant consumerReg = consumer.getServiceMetadata().getRegistrant();
        Registrant providerReg = provider == null ? null : provider.getServiceMetadata().getRegistrant();
        String intf = this.getInterface(consumer, provider, consumerReg);
        SecurityContextManager scm = new SecurityContextManager(exch.getConsumer().getDomain());
        SecurityContext securityContext = scm.getContext(exch);
        ExchangeContract contract = exch.getContract();
        QName serviceType = consumer.getName();
        String opName = contract.getConsumerOperation().getName();
        Property rrtw = exch.getContext().getProperty(RTGOV_REQUEST_RECEIVED);
        Property rstw = exch.getContext().getProperty(RTGOV_REQUEST_SENT);
        RequestReceived rr = rrtw == null ? null : (RequestReceived)rrtw.getValue();
        RequestSent requestSent = rs = rstw == null ? null : (RequestSent)rstw.getValue();
        if (intf != null) {
            if (rr != null) {
                rr.setInterface(intf);
            }
            if (rs != null) {
                rs.setInterface(intf);
            }
        }
        if (providerReg == null || !providerReg.isBinding()) {
            ResponseSent sent = new ResponseSent();
            if (providerReg == null || !providerReg.isBinding()) {
                sent.setServiceType(serviceType.toString());
            }
            sent.setInterface(intf);
            sent.setOperation(opName);
            sent.setMessageId(messageId);
            if (consumerReg.isBinding()) {
                gatewayName = (String)exch.getContext().getPropertyValue("org.switchyard.exchangeGatewayName");
                bindings = (List)consumerReg.getConfig();
                for (i = 0; gatewayName != null && i < bindings.size(); ++i) {
                    bm = (BindingModel)bindings.get(i);
                    if (!gatewayName.equals(bm.getName())) continue;
                    sent.getProperties().put(GATEWAY_PROPERTY, bm.getType());
                }
            }
            if (relatesTo == null && rr != null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Exception seems to have occurred, so establishing relationship to original request: " + rr.getMessageId());
                }
                relatesTo = rr.getMessageId();
            }
            sent.setReplyToId(relatesTo);
            this.record(mesg, contentType, (RPCActivityType)sent, securityContext, exch);
        }
        if (consumerReg.isBinding()) {
            this.getActivityCollector().endScope();
        } else {
            ResponseReceived recvd = new ResponseReceived();
            recvd.setServiceType(serviceType.toString());
            recvd.setInterface(intf);
            recvd.setOperation(opName);
            recvd.setMessageId(messageId);
            recvd.setReplyToId(relatesTo);
            if (providerReg != null && providerReg.isBinding()) {
                gatewayName = (String)exch.getContext().getPropertyValue("org.switchyard.exchangeGatewayName");
                bindings = (List)providerReg.getConfig();
                for (i = 0; gatewayName != null && i < bindings.size(); ++i) {
                    bm = (BindingModel)bindings.get(i);
                    if (!gatewayName.equals(bm.getName())) continue;
                    recvd.getProperties().put(GATEWAY_PROPERTY, bm.getType());
                }
            }
            this.record(mesg, contentType, (RPCActivityType)recvd, securityContext, exch);
        }
    }

    protected String getInterface(ServiceReference consumer, Service provider, Registrant consumerReg) {
        String ret = null;
        ServiceInterface intf = null;
        if (consumerReg.isBinding()) {
            intf = consumer.getInterface();
        } else if (provider != null) {
            intf = provider.getInterface();
        }
        if (intf != null) {
            if ("java".equals(intf.getType())) {
                ret = ((JavaService)intf).getJavaInterface().getName();
            } else if ("wsdl".equals(intf.getType())) {
                ret = ((WSDLService)intf).getPortType().toString();
            }
        }
        return ret;
    }

    protected void record(Message msg, String contentType, RPCActivityType at, SecurityContext sc, Exchange exch) {
        if (at != null) {
            if (msg != null) {
                Object content = msg.getContent();
                if (contentType == null) {
                    if (!(content instanceof HandlerException)) {
                        contentType = content.getClass().getName();
                        String faultName = content.getClass().getSimpleName();
                        if (faultName != null && faultName.endsWith("Exception")) {
                            faultName = faultName.substring(0, faultName.length() - 9);
                        }
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("Setting fault for type '" + contentType + "' to: " + faultName);
                        }
                        at.setFault(faultName);
                    } else {
                        at.setFault(UNEXPECTED_FAULT);
                    }
                }
                if (contentType != null) {
                    at.setContent(this.getActivityCollector().processInformation(null, contentType, content, (Map)new PropertyAccessor(msg.getContext()), (ActivityType)at));
                } else if (content != null) {
                    at.setContent(content.toString());
                }
            }
            at.setMessageType(contentType);
            if (sc != null && sc.getCredentials().size() > 0) {
                for (Credential cred : sc.getCredentials()) {
                    if (cred instanceof NameCredential) {
                        at.setPrincipal(((NameCredential)cred).getName());
                        break;
                    }
                    if (!(cred instanceof PrincipalCredential)) continue;
                    at.setPrincipal(((PrincipalCredential)cred).getPrincipal().getName());
                    break;
                }
            }
            this.recordActivity(exch, (ActivityType)at);
        }
    }
}

