/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.internal.switchyard;

import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.activity.collector.ActivityCollector;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.internal.switchyard.EventProcessor;
import org.switchyard.event.EventObserver;

public abstract class AbstractEventProcessor
implements EventObserver,
EventProcessor {
    private static final Logger LOG = Logger.getLogger(AbstractEventProcessor.class.getName());
    private Class<?> _class = null;
    private ActivityCollector _collector = null;

    public AbstractEventProcessor(Class<?> cls) {
        this._class = cls;
    }

    @Override
    public void init(ActivityCollector collector) {
        this._collector = collector;
    }

    @Override
    public Class<?> getEventType() {
        return this._class;
    }

    protected ActivityCollector getActivityCollector() {
        return this._collector;
    }

    public final void notify(EventObject event) {
        if (this.isCollectionEnabled()) {
            this.handleEvent(event);
        }
    }

    protected abstract void handleEvent(EventObject var1);

    protected boolean isCollectionEnabled() {
        return this._collector == null ? false : this._collector.isCollectionEnabled();
    }

    protected void recordActivity(Object event, ActivityType at) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Record event '" + event + "' as activity type: " + at);
        }
        this.getActivityCollector().record(at);
    }
}

