/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.internal.switchyard;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.overlord.commons.services.ServiceListener;
import org.overlord.commons.services.ServiceRegistryUtil;
import org.overlord.rtgov.activity.collector.ActivityCollector;
import org.overlord.rtgov.internal.switchyard.EventProcessor;
import org.switchyard.event.EventObserver;

@ApplicationScoped
@Singleton
@Startup
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class EventProcessorManager {
    private static final String SWITCHYARD_MANAGEMENT_LOCAL = "org.switchyard.admin:type=Management.Local";
    private static final Logger LOG = Logger.getLogger(EventProcessorManager.class.getName());
    private ActivityCollector _activityCollector = null;
    private List<EventProcessor> _eventProcessors = new ArrayList<EventProcessor>();
    private static final String[] EVENT_PROCESSOR_CLASS_NAMES = new String[]{"org.overlord.rtgov.internal.switchyard.bpel.NewProcessInstanceEventProcessor", "org.overlord.rtgov.internal.switchyard.bpel.ProcessCompletionEventProcessor", "org.overlord.rtgov.internal.switchyard.bpel.ProcessTerminationEventProcessor", "org.overlord.rtgov.internal.switchyard.bpel.VariableModificationEventProcessor", "org.overlord.rtgov.internal.switchyard.bpm.ProcessCompletedEventProcessor", "org.overlord.rtgov.internal.switchyard.bpm.ProcessStartedEventProcessor", "org.overlord.rtgov.internal.switchyard.bpm.ProcessVariableChangedEventProcessor", "org.overlord.rtgov.internal.switchyard.exchange.ExchangeCompletionEventProcessor", "org.overlord.rtgov.internal.switchyard.exchange.ExchangeInitiatedEventProcessor"};

    public void setActivityCollector(ActivityCollector ac) {
        this._activityCollector = ac;
    }

    public ActivityCollector getActivityCollector() {
        return this._activityCollector;
    }

    @PostConstruct
    public void init() {
        block8: {
            if (this._activityCollector == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("SwitchYard EventProcessorManager retrieving activity collector");
                }
                ServiceRegistryUtil.addServiceListener(ActivityCollector.class, (ServiceListener)new ServiceListener<ActivityCollector>(){

                    public void registered(ActivityCollector service) {
                        EventProcessorManager.this._activityCollector = service;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Event processor manager: collector=" + EventProcessorManager.this._activityCollector);
                        }
                    }

                    public void unregistered(ActivityCollector service) {
                        EventProcessorManager.this._activityCollector = null;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Event processor manager: collector unset");
                        }
                    }
                });
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("SwitchYard EventProcessorManager Initialized with collector=" + this._activityCollector);
            }
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objname = null;
            try {
                String observerClassName = EventObserver.class.getName();
                objname = new ObjectName(SWITCHYARD_MANAGEMENT_LOCAL);
                for (String clsName : EVENT_PROCESSOR_CLASS_NAMES) {
                    Class<?> cls = EventProcessorManager.class.getClassLoader().loadClass(clsName);
                    EventProcessor ep = (EventProcessor)cls.newInstance();
                    this._eventProcessors.add(ep);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("SwitchYard EventProcessorManager register event processor=" + ep);
                    }
                    ep.init(this._activityCollector);
                    ArrayList eventTypes = new ArrayList();
                    eventTypes.add(ep.getEventType());
                    Object[] params = new Object[]{ep, eventTypes};
                    String[] types = new String[]{observerClassName, List.class.getName()};
                    mbs.invoke(objname, "addObserver", params, types);
                }
            }
            catch (Throwable e) {
                if (!LOG.isLoggable(Level.FINE)) break block8;
                LOG.log(Level.FINE, "Failed to register SwitchYard event processor", e);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("SwitchYard EventProcessorManager Initialization Completed");
        }
    }

    @PreDestroy
    public void close() {
        block5: {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objname = null;
            try {
                objname = new ObjectName(SWITCHYARD_MANAGEMENT_LOCAL);
                for (EventProcessor ep : this._eventProcessors) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("SwitchYard EventProcessorManager unregister event processor=" + ep);
                    }
                    Object[] params = new Object[]{ep};
                    String[] types = new String[]{EventObserver.class.getName()};
                    if (!mbs.isRegistered(objname)) continue;
                    mbs.invoke(objname, "removeObserver", params, types);
                }
            }
            catch (Throwable e) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.log(Level.FINE, "Failed to unregister SwitchYard event observer via MBean", e);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("SwitchYard EventProcessorManager Close Completed");
        }
    }
}

