/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.internal.switchyard.bpel;

import java.util.EventObject;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.bpm.ProcessVariableSet;
import org.overlord.rtgov.internal.switchyard.AbstractEventProcessor;
import org.w3c.dom.Node;

public class VariableModificationEventProcessor
extends AbstractEventProcessor {
    public VariableModificationEventProcessor() {
        super(VariableModificationEvent.class);
    }

    @Override
    public void handleEvent(EventObject event) {
        VariableModificationEvent bpelEvent = (VariableModificationEvent)event;
        ProcessVariableSet pvs = new ProcessVariableSet();
        Node value = bpelEvent.getNewValue();
        if (value.getLocalName().equals("message") && value.getChildNodes().getLength() == 1) {
            value = value.getFirstChild().getFirstChild();
        } else if (value.getLocalName().equals("temporary-simple-type-wrapper")) {
            value = value.getFirstChild();
        }
        String type = value.getLocalName();
        if (value.getNamespaceURI() != null) {
            type = "{" + value.getNamespaceURI() + "}" + type;
        }
        pvs.setVariableName(bpelEvent.getVarName());
        pvs.setVariableType(type);
        pvs.setVariableValue(this.getActivityCollector().processInformation(null, type, (Object)value, null, (ActivityType)pvs));
        pvs.setProcessType(bpelEvent.getProcessName().toString());
        pvs.setInstanceId(bpelEvent.getProcessInstanceId().toString());
        this.recordActivity(event, (ActivityType)pvs);
    }
}

