/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.switchyard.exchange;

import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.overlord.commons.services.ServiceListener;
import org.overlord.commons.services.ServiceRegistryUtil;
import org.overlord.rtgov.activity.collector.ActivityCollector;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.soa.RPCActivityType;
import org.overlord.rtgov.activity.model.soa.RequestReceived;
import org.overlord.rtgov.activity.model.soa.RequestSent;
import org.overlord.rtgov.activity.model.soa.ResponseReceived;
import org.overlord.rtgov.activity.model.soa.ResponseSent;
import org.overlord.rtgov.common.util.RTGovProperties;
import org.overlord.rtgov.internal.switchyard.exchange.PropertyAccessor;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.Service;
import org.switchyard.ServiceReference;
import org.switchyard.extensions.java.JavaService;
import org.switchyard.extensions.wsdl.WSDLService;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.context.SecurityContextManager;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.NameCredential;
import org.switchyard.security.credential.PrincipalCredential;

public class AbstractExchangeValidator {
    private static final Logger LOG = Logger.getLogger(AbstractExchangeValidator.class.getName());
    private static final String JAVAX_TRANSACTION_MANAGER = "javax.transaction.manager";
    private static final String JBOSS_TRANSACTION_MANAGER = "java:jboss/TransactionManager";
    private TransactionManager _transactionManager = null;
    private ActivityCollector _activityCollector = null;

    @PostConstruct
    protected void init() {
        ServiceRegistryUtil.addServiceListener(ActivityCollector.class, (ServiceListener)new ServiceListener<ActivityCollector>(){

            public void registered(ActivityCollector service) {
                AbstractExchangeValidator.this._activityCollector = service;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Exchange Validator: collector=" + AbstractExchangeValidator.this._activityCollector);
                }
            }

            public void unregistered(ActivityCollector service) {
                AbstractExchangeValidator.this._activityCollector = null;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Exchange Validator: collector unset");
                }
            }
        });
        try {
            String txnMgr = RTGovProperties.getProperty((String)JAVAX_TRANSACTION_MANAGER);
            if (txnMgr == null) {
                txnMgr = JBOSS_TRANSACTION_MANAGER;
            }
            InitialContext ctx = new InitialContext();
            this._transactionManager = (TransactionManager)ctx.lookup(txnMgr);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Transaction manager '" + txnMgr + "' = " + this._transactionManager);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("rtgov-jbossas.Messages").getString("RTGOV-JBOSSAS-1"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleExchange(Exchange exch) throws HandlerException {
        Message mesg = exch.getMessage();
        ExchangePhase phase = exch.getPhase();
        if (mesg == null) {
            LOG.severe("Could not obtain message for phase (" + phase + ") and exchange: " + exch);
            return;
        }
        Context context = exch.getContext();
        Service provider = exch.getProvider();
        ServiceReference consumer = exch.getConsumer();
        SecurityContextManager scm = new SecurityContextManager(exch.getConsumer().getDomain());
        SecurityContext securityContext = scm.getContext(exch);
        ExchangeContract contract = exch.getContract();
        if (provider == null && LOG.isLoggable(Level.FINEST)) {
            LOG.finest("No provider specified - probably an exception: " + mesg.getContent());
        }
        if (this._activityCollector != null) {
            boolean f_txnStarted = false;
            try {
                if (this._transactionManager != null && this._transactionManager.getTransaction() == null) {
                    this._transactionManager.begin();
                    f_txnStarted = true;
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Validator txn has started");
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to start validator transaction", e);
            }
            try {
                String messageId = null;
                Property mip = context.getProperty("org.switchyard.messageId", Scope.MESSAGE);
                if (mip != null) {
                    messageId = (String)mip.getValue();
                }
                String contentType = null;
                Property ctp = context.getProperty("org.switchyard.contentType", Scope.MESSAGE);
                if (ctp != null && (contentType = ((QName)ctp.getValue()).toString()) != null && contentType.startsWith("java:")) {
                    contentType = contentType.substring(5);
                }
                QName serviceType = consumer.getName();
                String opName = contract.getConsumerOperation().getName();
                if (phase == ExchangePhase.IN) {
                    if (!consumer.getServiceMetadata().getRegistrant().isBinding()) {
                        RequestSent sent = new RequestSent();
                        if (provider == null || !provider.getServiceMetadata().getRegistrant().isBinding()) {
                            sent.setServiceType(serviceType.toString());
                        }
                        sent.setInterface(this.getInterface(consumer, provider));
                        sent.setOperation(opName);
                        sent.setMessageId(messageId);
                        this.validate(mesg, contentType, (RPCActivityType)sent, securityContext);
                    }
                    if (provider == null || !provider.getServiceMetadata().getRegistrant().isBinding()) {
                        RequestReceived recvd = new RequestReceived();
                        recvd.setServiceType(serviceType.toString());
                        recvd.setInterface(this.getInterface(consumer, provider));
                        recvd.setOperation(opName);
                        recvd.setMessageId(messageId);
                        this.validate(mesg, contentType, (RPCActivityType)recvd, securityContext);
                    }
                } else if (phase == ExchangePhase.OUT) {
                    if (contentType == null) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("No content type - possibly due to exception on handling the request");
                        }
                        return;
                    }
                    String relatesTo = null;
                    Property rtp = context.getProperty("org.switchyard.relatesTo", Scope.MESSAGE);
                    if (rtp != null) {
                        relatesTo = (String)rtp.getValue();
                    }
                    if (provider == null || !provider.getServiceMetadata().getRegistrant().isBinding()) {
                        ResponseSent sent = new ResponseSent();
                        if (provider == null || !provider.getServiceMetadata().getRegistrant().isBinding()) {
                            sent.setServiceType(serviceType.toString());
                        }
                        sent.setInterface(this.getInterface(consumer, provider));
                        sent.setOperation(opName);
                        sent.setMessageId(messageId);
                        sent.setReplyToId(relatesTo);
                        this.validate(mesg, contentType, (RPCActivityType)sent, securityContext);
                    }
                    if (!consumer.getServiceMetadata().getRegistrant().isBinding()) {
                        ResponseReceived recvd = new ResponseReceived();
                        recvd.setServiceType(serviceType.toString());
                        recvd.setInterface(this.getInterface(consumer, provider));
                        recvd.setOperation(opName);
                        recvd.setMessageId(messageId);
                        recvd.setReplyToId(relatesTo);
                        this.validate(mesg, contentType, (RPCActivityType)recvd, securityContext);
                    }
                }
            }
            finally {
                if (f_txnStarted) {
                    try {
                        this._transactionManager.commit();
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("Validator txn has committed");
                        }
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Failed to commit validator transaction", e);
                    }
                }
            }
        }
    }

    protected String getInterface(ServiceReference consumer, Service provider) {
        String ret = null;
        ServiceInterface intf = null;
        intf = consumer.getServiceMetadata().getRegistrant().isBinding() ? consumer.getInterface() : provider.getInterface();
        if ("java".equals(intf.getType())) {
            ret = ((JavaService)intf).getJavaInterface().getName();
        } else if ("wsdl".equals(intf.getType())) {
            ret = ((WSDLService)intf).getPortType().toString();
        }
        return ret;
    }

    protected void validate(Message msg, String contentType, RPCActivityType at, SecurityContext sc) throws HandlerException {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Validate msg=" + msg + " contentType=" + contentType + " at=" + at);
        }
        if (at != null) {
            at.setMessageType(contentType);
            Object content = msg.getContent();
            at.setContent(this._activityCollector.processInformation(null, contentType, content, (Map)new PropertyAccessor(msg.getContext()), (ActivityType)at));
            if (sc != null) {
                for (Credential cred : sc.getCredentials()) {
                    if (cred instanceof NameCredential) {
                        at.setPrincipal(((NameCredential)cred).getName());
                        break;
                    }
                    if (!(cred instanceof PrincipalCredential)) continue;
                    at.setPrincipal(((PrincipalCredential)cred).getPrincipal().getName());
                    break;
                }
            }
            try {
                this._activityCollector.validate((ActivityType)at);
            }
            catch (Exception e) {
                throw new HandlerException(e.getMessage());
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Activity is valid: at=" + at);
            }
        }
    }
}

