/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.ui.provider.situations;

import java.util.Date;
import org.overlord.rtgov.activity.model.Context;
import org.overlord.rtgov.analytics.situation.Situation;
import org.overlord.rtgov.ui.client.model.NameValuePairBean;
import org.overlord.rtgov.ui.client.model.SituationBean;
import org.overlord.rtgov.ui.client.model.SituationEventBean;

public class RTGovSituationsUtil {
    private RTGovSituationsUtil() {
    }

    public static SituationBean getSituationBean(Situation situation) {
        SituationBean ret = new SituationBean();
        ret.setSituationId(situation.getId());
        if (situation.getSeverity() != null) {
            ret.setSeverity(situation.getSeverity().name().toLowerCase());
        }
        ret.setType(situation.getType());
        ret.setSubject(situation.getSubject());
        ret.setTimestamp(new Date(situation.getTimestamp()));
        ret.setDescription(situation.getDescription());
        ret.getProperties().putAll(situation.getProperties());
        for (Context context : situation.getContext()) {
            if (context.getType() == Context.Type.Message) continue;
            ret.getContext().add(new NameValuePairBean(context.getType().name(), context.getValue()));
        }
        return ret;
    }

    public static SituationEventBean getSituationEventBean(Situation situation) {
        SituationEventBean ret = new SituationEventBean();
        ret.setSituationId(situation.getId());
        if (situation.getSeverity() != null) {
            ret.setSeverity(situation.getSeverity().name().toLowerCase());
        }
        ret.setType(situation.getType());
        ret.setSubject(situation.getSubject());
        ret.setTimestamp(new Date(situation.getTimestamp()));
        return ret;
    }
}

