/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.ui.provider.situations;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.overlord.rtgov.active.collection.ActiveChangeListener;
import org.overlord.rtgov.active.collection.ActiveCollection;
import org.overlord.rtgov.active.collection.ActiveCollectionListener;
import org.overlord.rtgov.active.collection.ActiveCollectionManager;
import org.overlord.rtgov.active.collection.ActiveCollectionManagerAccessor;
import org.overlord.rtgov.active.collection.ActiveList;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.ActivityTypeId;
import org.overlord.rtgov.activity.model.ActivityUnit;
import org.overlord.rtgov.activity.model.Context;
import org.overlord.rtgov.activity.model.soa.RPCActivityType;
import org.overlord.rtgov.activity.server.ActivityServer;
import org.overlord.rtgov.activity.server.ActivityStore;
import org.overlord.rtgov.activity.server.ActivityStoreFactory;
import org.overlord.rtgov.activity.server.QuerySpec;
import org.overlord.rtgov.analytics.situation.Situation;
import org.overlord.rtgov.analytics.situation.store.ResolutionState;
import org.overlord.rtgov.analytics.situation.store.SituationStore;
import org.overlord.rtgov.analytics.situation.store.SituationStoreFactory;
import org.overlord.rtgov.analytics.situation.store.SituationsQuery;
import org.overlord.rtgov.call.trace.CallTraceService;
import org.overlord.rtgov.call.trace.CallTraceServiceImpl;
import org.overlord.rtgov.call.trace.model.Call;
import org.overlord.rtgov.call.trace.model.CallTrace;
import org.overlord.rtgov.call.trace.model.Task;
import org.overlord.rtgov.call.trace.model.TraceNode;
import org.overlord.rtgov.ui.client.model.BatchRetryResult;
import org.overlord.rtgov.ui.client.model.CallTraceBean;
import org.overlord.rtgov.ui.client.model.MessageBean;
import org.overlord.rtgov.ui.client.model.SituationBean;
import org.overlord.rtgov.ui.client.model.SituationEventBean;
import org.overlord.rtgov.ui.client.model.SituationSummaryBean;
import org.overlord.rtgov.ui.client.model.SituationsFilterBean;
import org.overlord.rtgov.ui.client.model.TraceNodeBean;
import org.overlord.rtgov.ui.client.model.UiException;
import org.overlord.rtgov.ui.provider.ServicesProvider;
import org.overlord.rtgov.ui.provider.SituationEventListener;
import org.overlord.rtgov.ui.provider.SituationsProvider;
import org.overlord.rtgov.ui.provider.situations.Messages;
import org.overlord.rtgov.ui.provider.situations.RTGovSituationsUtil;
import org.overlord.rtgov.ui.server.interceptors.IUserContext;

public class RTGovSituationsProvider
implements SituationsProvider,
ActiveChangeListener {
    private static final String PROVIDER_NAME = "rtgov";
    private static final String SITUATIONS = "Situations";
    protected static final int MILLISECONDS_PER_DAY = 86400000;
    private static volatile Messages i18n = new Messages();
    private CallTraceService _callTraceService = new CallTraceServiceImpl();
    private ActivityStore _activityStore;
    private SituationStore _situationStore;
    @Inject
    private Instance<ServicesProvider> _injectedProviders;
    private List<ServicesProvider> _providers = new ArrayList<ServicesProvider>();
    private List<SituationEventListener> _listeners = new ArrayList<SituationEventListener>();
    private ActiveList _situations;
    private ActiveCollectionManager _acmManager;

    protected List<ServicesProvider> getProviders() {
        return this._providers;
    }

    protected void setActivityStore(ActivityStore acts) {
        this._activityStore = acts;
    }

    protected ActivityStore getActivityStore() {
        return this._activityStore;
    }

    protected void setSituationStore(SituationStore sits) {
        this._situationStore = sits;
    }

    protected SituationStore getSituationStore() {
        return this._situationStore;
    }

    protected void setCallTraceService(CallTraceService cts) {
        this._callTraceService = cts;
    }

    protected CallTraceService getCallTraceService() {
        return this._callTraceService;
    }

    protected void setSituations(ActiveList situations) {
        this._situations = situations;
    }

    protected ActiveList getSituations() {
        return this._situations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        if (this._activityStore == null) {
            this._activityStore = ActivityStoreFactory.getActivityStore();
        }
        if (this._situationStore == null) {
            this._situationStore = SituationStoreFactory.getSituationStore();
        }
        if (this._injectedProviders != null) {
            for (ServicesProvider sp : this._injectedProviders) {
                this._providers.add(sp);
            }
        }
        if (this._callTraceService != null) {
            this._callTraceService.setActivityServer((ActivityServer)new ActivityServerAdapter());
        }
        if (this._situations == null) {
            this._acmManager = ActiveCollectionManagerAccessor.getActiveCollectionManager();
            this._acmManager.addActiveCollectionListener(new ActiveCollectionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void registered(ActiveCollection ac) {
                    if (!ac.getName().equals(RTGovSituationsProvider.SITUATIONS)) return;
                    String string = RTGovSituationsProvider.SITUATIONS;
                    synchronized (RTGovSituationsProvider.SITUATIONS) {
                        if (RTGovSituationsProvider.this._situations != null) return;
                        RTGovSituationsProvider.this._situations = (ActiveList)ac;
                        RTGovSituationsProvider.this._situations.addActiveChangeListener((ActiveChangeListener)RTGovSituationsProvider.this);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                public void unregistered(ActiveCollection ac) {
                }
            });
        }
        String string = SITUATIONS;
        synchronized (SITUATIONS) {
            if (this._situations == null) {
                this._situations = (ActiveList)this._acmManager.getActiveCollection(SITUATIONS);
            }
            if (this._situations != null) {
                this._situations.addActiveChangeListener((ActiveChangeListener)this);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSituationEventListener(SituationEventListener l) {
        List<SituationEventListener> list = this._listeners;
        synchronized (list) {
            this._listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSituationEventListener(SituationEventListener l) {
        List<SituationEventListener> list = this._listeners;
        synchronized (list) {
            this._listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSituationEvent(SituationEventBean event) {
        List<SituationEventListener> list = this._listeners;
        synchronized (list) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                this._listeners.get(i).onSituationEvent(event);
            }
        }
    }

    public List<SituationSummaryBean> search(SituationsFilterBean filters) throws UiException {
        ArrayList<SituationSummaryBean> situations = new ArrayList<SituationSummaryBean>();
        try {
            SituationsQuery query = RTGovSituationsProvider.createQuery(filters);
            List results = this._situationStore.getSituations(query);
            for (Situation item : results) {
                situations.add((SituationSummaryBean)RTGovSituationsUtil.getSituationBean(item));
            }
        }
        catch (Exception e) {
            throw new UiException((Throwable)e);
        }
        return situations;
    }

    protected static SituationsQuery createQuery(SituationsFilterBean filters) {
        SituationsQuery ret = new SituationsQuery();
        ret.setType(filters.getType());
        if (filters.getSeverity() != null && filters.getSeverity().trim().length() > 0) {
            String severityName = Character.toUpperCase(filters.getSeverity().charAt(0)) + filters.getSeverity().substring(1);
            ret.setSeverity(Situation.Severity.valueOf((String)severityName));
        }
        if (filters.getTimestampFrom() != null) {
            ret.setFromTimestamp(filters.getTimestampFrom().getTime());
        }
        if (filters.getTimestampTo() != null) {
            ret.setToTimestamp(filters.getTimestampTo().getTime());
        }
        ret.setDescription(filters.getDescription());
        ret.setResolutionState(filters.getResolutionState());
        ret.setSubject(filters.getSubject());
        try {
            ret.setProperties(filters.getProperties());
        }
        catch (IOException ioException) {
            Throwables.propagate((Throwable)ioException);
        }
        return ret;
    }

    public SituationBean getSituation(String situationId) throws UiException {
        SituationBean ret = null;
        try {
            Situation situation = this._situationStore.getSituation(situationId);
            if (situation == null) {
                throw new UiException(i18n.format("RTGovSituationsProvider.SitNotFound", new Object[]{situationId}));
            }
            ret = RTGovSituationsUtil.getSituationBean(situation);
            MessageBean message = this.getMessage(situation);
            ret.setMessage(message);
            CallTraceBean callTrace = this.getCallTrace(situation);
            ret.setCallTrace(callTrace);
            ret.setResubmitPossible(Iterables.any(this._providers, (Predicate)new IsResubmitSupported(situation)));
        }
        catch (UiException uie) {
            throw uie;
        }
        catch (Exception e) {
            throw new UiException("Failed to retrieve situation", (Throwable)e);
        }
        return ret;
    }

    protected MessageBean getMessage(Situation situation) throws UiException {
        MessageBean ret = null;
        for (ActivityTypeId id : situation.getActivityTypeIds()) {
            try {
                ActivityType at = null;
                ActivityUnit au = this._activityStore.getActivityUnit(id.getUnitId());
                if (au != null && id.getUnitIndex() < au.getActivityTypes().size()) {
                    at = (ActivityType)au.getActivityTypes().get(id.getUnitIndex());
                }
                if (!(at instanceof RPCActivityType) || !((RPCActivityType)at).isRequest() || ((RPCActivityType)at).getContent() == null) continue;
                ret = new MessageBean();
                ret.setContent(((RPCActivityType)at).getContent());
                break;
            }
            catch (Exception e) {
                throw new UiException("Failed to get message for activity type id '" + id + "'", (Throwable)e);
            }
        }
        return ret;
    }

    protected CallTraceBean getCallTrace(Situation situation) throws UiException {
        CallTraceBean ret = new CallTraceBean();
        Context context = null;
        for (Context c : situation.getContext()) {
            if (c.getType() != Context.Type.Conversation) continue;
            context = c;
            break;
        }
        if (context == null && situation.getContext().size() > 0) {
            context = (Context)situation.getContext().iterator().next();
        }
        if (context != null && this._callTraceService != null) {
            try {
                CallTrace ct = this._callTraceService.createCallTrace(context);
                if (ct != null) {
                    for (TraceNode tn : ct.getTasks()) {
                        ret.getTasks().add(this.createTraceNode(tn));
                    }
                }
            }
            catch (Exception e) {
                throw new UiException("Failed to get call trace for context '" + context + "'", (Throwable)e);
            }
        }
        return ret;
    }

    protected TraceNodeBean createTraceNode(TraceNode node) {
        TraceNodeBean ret = new TraceNodeBean();
        ret.setType(node.getClass().getSimpleName());
        ret.setStatus(node.getStatus().name());
        if (node instanceof Task) {
            Task task = (Task)node;
            ret.setDescription(task.getDescription());
        } else if (node instanceof Call) {
            Call call = (Call)node;
            ret.setIface(call.getInterface());
            ret.setOperation(call.getOperation());
            ret.setDuration(call.getDuration());
            ret.setPercentage(call.getPercentage());
            ret.setComponent(call.getComponent());
            ret.setFault(call.getFault());
            ret.setPrincipal(call.getPrincipal());
            ret.setRequest(call.getRequest());
            ret.setResponse(call.getResponse());
            ret.setRequestLatency(call.getRequestLatency());
            ret.setResponseLatency(call.getResponseLatency());
            ret.setProperties(call.getProperties());
            for (TraceNode child : call.getTasks()) {
                ret.getTasks().add(this.createTraceNode(child));
            }
        }
        return ret;
    }

    public void resubmit(String situationId, MessageBean message) throws UiException {
        Situation situation = this._situationStore.getSituation(situationId);
        if (situation == null) {
            throw new UiException(i18n.format("RTGovSituationsProvider.SitNotFound", new Object[]{situationId}));
        }
        this.resubmitInternal(situation, message);
    }

    private void resubmitInternal(Situation situation, MessageBean message) throws UiException {
        ServiceOperationName operationName = RTGovSituationsProvider.getServiceOperationName(situation);
        Optional serviceProvider = Iterables.tryFind(this._providers, (Predicate)new IsResubmitSupported(operationName));
        if (!serviceProvider.isPresent()) {
            throw new UiException(i18n.format("RTGovSituationsProvider.ResubmitProviderNotFound", new Object[]{situation.getId()}));
        }
        String userName = null;
        if (IUserContext.Holder.getUserPrincipal() != null) {
            userName = IUserContext.Holder.getUserPrincipal().getName();
        }
        try {
            ((ServicesProvider)serviceProvider.get()).resubmit(operationName.getService(), operationName.getOperation(), message);
            this._situationStore.recordSuccessfulResubmit(situation.getId(), userName);
        }
        catch (Exception exception) {
            this._situationStore.recordResubmitFailure(situation.getId(), Throwables.getStackTraceAsString((Throwable)exception), userName);
            throw new UiException(i18n.format("RTGovSituationsProvider.ResubmitFailed", new Object[]{situation.getId() + ":" + exception.getLocalizedMessage()}), (Throwable)exception);
        }
    }

    public BatchRetryResult resubmit(SituationsFilterBean situationsFilterBean) throws UiException {
        int processedCount = 0;
        int failedCount = 0;
        int ignoredCount = 0;
        List situationIdToactivityTypeIds = this._situationStore.getSituations(RTGovSituationsProvider.createQuery(situationsFilterBean));
        for (Situation situation : situationIdToactivityTypeIds) {
            MessageBean message = this.getMessage(situation);
            if (message == null) {
                ++ignoredCount;
                continue;
            }
            try {
                ++processedCount;
                this.resubmitInternal(situation, message);
            }
            catch (UiException uiException) {
                ++failedCount;
            }
        }
        return new BatchRetryResult(processedCount, failedCount, ignoredCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(SituationsFilterBean situationsFilterBean, OutputStream outputStream) {
        List situationIdToactivityTypeIds = this._situationStore.getSituations(RTGovSituationsProvider.createQuery(situationsFilterBean));
        PrintWriter printWriter = new PrintWriter(outputStream);
        try {
            for (Situation situation : situationIdToactivityTypeIds) {
                MessageBean message = this.getMessage(situation);
                if (message == null) continue;
                printWriter.println(message.getContent());
            }
        }
        catch (UiException uiException) {
            Throwables.propagate((Throwable)uiException);
        }
        finally {
            if (null != printWriter) {
                printWriter.close();
            }
        }
    }

    public void inserted(Object key, Object value) {
        if (value instanceof Situation) {
            SituationEventBean event = RTGovSituationsUtil.getSituationEventBean((Situation)value);
            this.fireSituationEvent(event);
        }
    }

    public void updated(Object key, Object value) {
    }

    public void removed(Object key, Object value) {
    }

    public void assign(String situationId, String userName) throws UiException {
        try {
            this._situationStore.assignSituation(situationId, userName);
        }
        catch (Exception e) {
            throw new UiException((Throwable)e);
        }
    }

    public void close(String situationId) throws UiException {
        try {
            this._situationStore.closeSituation(situationId);
        }
        catch (Exception e) {
            throw new UiException((Throwable)e);
        }
    }

    public void updateResolutionState(String situationId, org.overlord.rtgov.ui.client.model.ResolutionState resolutionState) throws UiException {
        try {
            this._situationStore.updateResolutionState(situationId, ResolutionState.valueOf((String)resolutionState.name()));
        }
        catch (Exception e) {
            throw new UiException((Throwable)e);
        }
    }

    public int delete(SituationsFilterBean situationsFilterBean) throws UiException {
        try {
            return this._situationStore.delete(RTGovSituationsProvider.createQuery(situationsFilterBean));
        }
        catch (Exception e) {
            throw new UiException((Throwable)e);
        }
    }

    private static ServiceOperationName getServiceOperationName(Situation situation) throws UiException {
        if (situation == null) {
            throw new IllegalArgumentException("parameter 'situation' must not be null");
        }
        String[] parts = Strings.nullToEmpty((String)situation.getSubject()).split("\\x7C");
        if (parts.length < 2 || parts.length > 3) {
            throw new UiException(i18n.format("RTGovSituationsProvider.InvalidSubject", new Object[]{situation.getSubject(), parts.length}));
        }
        return new ServiceOperationName(parts[0], parts[1]);
    }

    private static class ServiceOperationName {
        private String service;
        private String operation;

        private ServiceOperationName(String service, String operation) {
            this.service = service;
            this.operation = operation;
        }

        public String getService() {
            return this.service;
        }

        public String getOperation() {
            return this.operation;
        }
    }

    private final class IsResubmitSupported
    implements Predicate<ServicesProvider> {
        private final ServiceOperationName operationName;

        private IsResubmitSupported(Situation situation) throws UiException {
            this(RTGovSituationsProvider.getServiceOperationName(situation));
        }

        private IsResubmitSupported(ServiceOperationName operationName) {
            this.operationName = operationName;
        }

        public boolean apply(ServicesProvider input) {
            try {
                return input.isResubmitSupported(this.operationName.getService(), this.operationName.getOperation());
            }
            catch (UiException e) {
                Throwables.propagate((Throwable)e);
                return false;
            }
        }
    }

    protected class ActivityServerAdapter
    implements ActivityServer {
        protected ActivityServerAdapter() {
        }

        public void store(List<ActivityUnit> activities) throws Exception {
        }

        public ActivityUnit getActivityUnit(String id) throws Exception {
            return RTGovSituationsProvider.this._activityStore.getActivityUnit(id);
        }

        public List<ActivityType> getActivityTypes(Context context) throws Exception {
            return RTGovSituationsProvider.this._activityStore.getActivityTypes(context);
        }

        public List<ActivityType> getActivityTypes(Context context, long from, long to) throws Exception {
            return RTGovSituationsProvider.this._activityStore.getActivityTypes(context, from, to);
        }

        public List<ActivityType> query(QuerySpec query) throws Exception {
            return RTGovSituationsProvider.this._activityStore.query(query);
        }
    }
}

