/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client;

import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.overlord.sramp.atom.providers.HttpResponseProvider;
import org.overlord.sramp.client.SrampClientExceptionReader;
import org.overlord.sramp.client.SrampServerException;

public class ClientRequest
extends org.jboss.resteasy.client.ClientRequest {
    private static final ResteasyProviderFactory providerFactory = new ResteasyProviderFactory();

    private static UriBuilder getBuilder(String uriTemplate) {
        return new UriBuilderImpl().uriTemplate(uriTemplate);
    }

    public ClientRequest(String uriTemplate) {
        super(ClientRequest.getBuilder(uriTemplate), ClientRequest.getDefaultExecutor(), providerFactory);
    }

    public <T> ClientResponse<T> post(Class<T> returnType) throws Exception {
        ClientResponse response = super.post(returnType);
        this.handlePotentialServerError(response);
        return response;
    }

    public <T> ClientResponse<T> get(Class<T> returnType) throws Exception {
        ClientResponse response = super.get(returnType);
        this.handlePotentialServerError(response);
        return response;
    }

    public <T> ClientResponse<T> put(Class<T> returnType) throws Exception {
        ClientResponse response = super.put(returnType);
        this.handlePotentialServerError(response);
        return response;
    }

    public <T> ClientResponse<T> delete(Class<T> returnType) throws Exception {
        ClientResponse response = super.delete(returnType);
        this.handlePotentialServerError(response);
        return response;
    }

    private <T> void handlePotentialServerError(ClientResponse<T> response) {
        String contentType = String.valueOf(response.getMetadata().getFirst((Object)"Content-Type"));
        if (response.getStatus() == 500) {
            SrampServerException error = new SrampServerException("An unexpected (and unknown) error was sent by the S-RAMP repository.");
            if ("application/stacktrace".equals(contentType)) {
                try {
                    SrampServerException entity = (SrampServerException)response.getEntity(SrampServerException.class);
                    if (entity != null) {
                        error = entity;
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw error;
        }
        if (response.getStatus() == 404) {
            SrampServerException error = new SrampServerException("The S-RAMP endpoint and/or method could not be found.");
            throw error;
        }
    }

    static {
        RegisterBuiltin.register((ResteasyProviderFactory)providerFactory);
        providerFactory.registerProvider(SrampClientExceptionReader.class);
        providerFactory.registerProvider(HttpResponseProvider.class);
    }
}

