/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.query.QueryResultSet;

public class SrampClientQuery {
    private SrampAtomApiClient client;
    private String queryTemplate;
    private List<String> replacementParams = new ArrayList<String>();
    private int startIndex = 0;
    private int count = 20;
    private String orderBy = "name";
    private boolean ascending = true;
    private Set<String> propertyNames = new HashSet<String>();

    protected SrampClientQuery(SrampAtomApiClient client, String queryTemplate) {
        this.client = client;
        this.queryTemplate = queryTemplate;
    }

    public SrampClientQuery parameter(String param) {
        this.replacementParams.add("'" + param.replace("'", "''") + "'");
        return this;
    }

    public SrampClientQuery parameter(int param) {
        this.replacementParams.add(String.valueOf(param));
        return this;
    }

    public SrampClientQuery parameter(long param) {
        this.replacementParams.add(String.valueOf(param));
        return this;
    }

    public SrampClientQuery parameter(double param) {
        this.replacementParams.add(String.valueOf(param));
        return this;
    }

    public SrampClientQuery parameter(float param) {
        this.replacementParams.add(String.valueOf(param));
        return this;
    }

    public SrampClientQuery parameter(Number param) {
        this.replacementParams.add(param.toString());
        return this;
    }

    public SrampClientQuery startIndex(int startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    public SrampClientQuery count(int count) {
        this.count = count;
        return this;
    }

    public SrampClientQuery orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public SrampClientQuery ascending() {
        this.ascending = true;
        return this;
    }

    public SrampClientQuery descending() {
        this.ascending = false;
        return this;
    }

    public SrampClientQuery propertyName(String propertyName) {
        this.propertyNames.add(propertyName);
        return this;
    }

    public QueryResultSet query() throws SrampClientException, SrampAtomException {
        String query = this.formatQuery();
        return this.client.query(query, this.startIndex, this.count, this.orderBy, this.ascending, this.propertyNames);
    }

    private String formatQuery() throws SrampClientException {
        StringBuilder builder = new StringBuilder();
        String[] xpathSegments = this.queryTemplate.split("\\?");
        int paramCounter = 0;
        for (String segment : xpathSegments) {
            boolean isLastSegment;
            builder.append(segment);
            boolean bl = isLastSegment = segment == xpathSegments[xpathSegments.length - 1];
            if (isLastSegment) continue;
            if (paramCounter >= this.replacementParams.size()) {
                throw new SrampClientException("Not enough query replacement parameters provided.");
            }
            String param = this.replacementParams.get(paramCounter);
            builder.append(param);
            ++paramCounter;
        }
        if (this.replacementParams.size() > paramCounter) {
            throw new SrampClientException("Too many query replacement parameters provided.");
        }
        return builder.toString();
    }
}

