/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.overlord.sramp.common.Sramp;
import org.overlord.sramp.server.i18n.Messages;
import org.overlord.sramp.server.services.MavenRepositoryService;
import org.overlord.sramp.server.services.mvn.MavenArtifactWrapper;
import org.overlord.sramp.server.services.mvn.MavenMetaData;
import org.overlord.sramp.server.services.mvn.MavenMetaDataBuilder;
import org.overlord.sramp.server.services.mvn.MavenRepositoryException;
import org.overlord.sramp.server.services.mvn.MavenRepositoryServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MavenRepositoryServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String JSP_LOCATION_LIST_DIR = "/list_items.jsp";
    private static final String URL_CONTEXT_STR = "maven/repository";
    private static Logger logger = LoggerFactory.getLogger(MavenRepositoryServlet.class);
    MavenRepositoryService service = new MavenRepositoryServiceImpl();
    private static boolean SNAPSHOT_ALLOWED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        MavenMetaData metadata;
        String url = req.getRequestURI();
        String maven_url = "";
        maven_url = url.contains("maven/repository") ? url.substring(url.indexOf("maven/repository") + "maven/repository".length()) : url;
        if (maven_url.startsWith("/")) {
            maven_url = maven_url.substring(1);
        }
        if ((metadata = MavenMetaDataBuilder.build((String)maven_url)).isArtifact()) {
            MavenArtifactWrapper artifact = null;
            try {
                artifact = this.service.getArtifactContent(metadata);
                if (artifact != null) {
                    resp.setContentLength(artifact.getContentLength());
                    resp.addHeader("Content-Disposition", "attachment; filename=" + artifact.getFileName());
                    resp.setContentType(artifact.getContentType());
                    IOUtils.copy((InputStream)artifact.getContent(), (OutputStream)resp.getOutputStream());
                }
                this.listItemsResponse(req, resp, maven_url);
            }
            catch (MavenRepositoryException e) {
                logger.info(Messages.i18n.format("maven.servlet.artifact.content.get.exception", new Object[]{metadata.getGroupId(), metadata.getArtifactId(), metadata.getVersion(), metadata.getFileName()}));
                resp.sendError(500);
            }
            finally {
                if (artifact != null) {
                    IOUtils.closeQuietly((InputStream)artifact.getContent());
                }
            }
        } else {
            this.listItemsResponse(req, resp, maven_url);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        this.uploadArtifact(req, response);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        this.uploadArtifact(req, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadArtifact(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        String url = req.getRequestURI();
        String maven_url = "";
        maven_url = url.contains("maven/repository") ? url.substring(url.indexOf("maven/repository") + "maven/repository".length()) : url;
        if (maven_url.startsWith("/")) {
            maven_url = maven_url.substring(1);
        }
        HashMap<String, String> responseMap = new HashMap<String, String>();
        ServletInputStream content = null;
        content = req.getInputStream();
        MavenMetaData metadata = MavenMetaDataBuilder.build((String)maven_url);
        try {
            if (metadata.isArtifact()) {
                if (SNAPSHOT_ALLOWED || !metadata.isSnapshotVersion()) {
                    String uuid = this.service.uploadArtifact(metadata, (InputStream)content);
                    responseMap.put("uuid", uuid);
                } else {
                    response.sendError(500, Messages.i18n.format("maven.servlet.put.snapshot.not.allowed", new Object[0]));
                }
            } else {
                response.sendError(400, Messages.i18n.format("maven.servlet.put.url.without.artifact", new Object[0]));
            }
        }
        catch (Throwable e) {
            logger.error(Messages.i18n.format("maven.servlet.artifact.content.put.exception", new Object[0]), e);
            response.sendError(500, Messages.i18n.format("maven.servlet.put.exception", new Object[0]));
        }
        finally {
            if (content != null) {
                IOUtils.closeQuietly((InputStream)content);
            }
        }
    }

    private void listItemsResponse(HttpServletRequest req, HttpServletResponse resp, String url) throws ServletException, IOException {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        try {
            Set items = this.service.getItems(url);
            if (items != null && items.size() > 0 || url.equals("/") || url.equals("")) {
                RequestDispatcher dispatcher = req.getRequestDispatcher("/list_items.jsp");
                if (StringUtils.isNotBlank((String)url) && !url.equals("/")) {
                    String[] urlTokens = url.split("/");
                    String parentPath = "";
                    if (urlTokens.length > 1) {
                        for (int i = 0; i < urlTokens.length - 1; ++i) {
                            parentPath = parentPath + urlTokens[i] + "/";
                        }
                    }
                    parentPath = "/" + parentPath;
                    req.setAttribute("parentPath", (Object)parentPath);
                } else {
                    url = "";
                }
                req.setAttribute("relativePath", (Object)url);
                req.setAttribute("items", (Object)items);
                dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            } else {
                resp.setStatus(404);
            }
        }
        catch (MavenRepositoryException e) {
            resp.sendError(404, e.getMessage());
        }
    }

    public static String getRootStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        MavenRepositoryServlet.getRootCause((Throwable)t).printStackTrace(writer);
        return sw.getBuffer().toString();
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable root;
        for (root = t; root.getCause() != null && root.getCause() != root; root = root.getCause()) {
        }
        return root;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        String url = req.getRequestURI();
        logger.info(Messages.i18n.format("maven.repository.servlet.service", new Object[]{method, url}));
        super.service(req, resp);
    }

    static {
        Sramp sramp = new Sramp();
        String value = sramp.getConfigProperty("sramp.config.maven.allow-snapshots", "false");
        SNAPSHOT_ALLOWED = StringUtils.isNotBlank((String)value) && value.equals("true");
    }
}

