/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services.brms;

import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.text.SimpleDateFormat;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.resteasy.plugins.providers.atom.Content;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.services.brms.Format;
import org.overlord.sramp.atom.services.brms.assets.Assets;
import org.overlord.sramp.atom.services.brms.packages.Packages;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampConstants;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.PersistenceManager;
import org.overlord.sramp.repository.QueryManager;
import org.overlord.sramp.repository.QueryManagerFactory;
import org.overlord.sramp.repository.query.ArtifactSet;
import org.overlord.sramp.repository.query.SrampQuery;
import org.overlord.sramp.server.atom.services.brms.BrmsResource;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactEnum;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.Property;

@Path(value="/brms")
public class BrmsResource {
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");

    @GET
    @Path(value="rest/packages/")
    @Produces(value={"application/xml", "application/atom+xml"})
    public Packages getRestAllPackages() throws SrampAtomException {
        try {
            ArtifactSet artifactSet = null;
            Packages brmsPackages = new Packages();
            QueryManager queryManager = QueryManagerFactory.newInstance();
            String query = String.format("/s-ramp/%1$s/%2$s", "ext", "BrmsPkgDocument");
            SrampQuery srampQuery = queryManager.createQuery(query, "name", true);
            artifactSet = srampQuery.executeQuery();
            for (BaseArtifactType artifact : artifactSet) {
                Packages.Package brmsPackage = new Packages.Package();
                brmsPackage.setTitle(artifact.getName().substring(0, artifact.getName().lastIndexOf(".")));
                brmsPackage.setPublished(artifact.getCreatedTimestamp());
                brmsPackage.setAuthor(artifact.getCreatedBy());
                brmsPackage.setDescription(artifact.getDescription());
                Packages.Package.Metadata metaData = new Packages.Package.Metadata();
                metaData.setUuid(artifact.getUuid());
                brmsPackage.setMetadata(metaData);
                brmsPackages.getPackage().add(brmsPackage);
            }
            return brmsPackages;
        }
        catch (Throwable e) {
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="rest/packages/{pkgName}/assets/")
    @Produces(value={"application/atom+xml", "application/xml"})
    public Assets getRestXMLAllAssetsInPackage(@PathParam(value="pkgName") String pkgName) throws SrampAtomException {
        Assets assets = new Assets();
        try {
            pkgName = pkgName + ".pkg";
            QueryManager queryManager = QueryManagerFactory.newInstance();
            String query = String.format("/s-ramp/%1$s/%2$s[@name='%3$s']", "ext", "BrmsPkgDocument", pkgName);
            SrampQuery srampQuery = queryManager.createQuery(query, "name", true);
            ArtifactSet artifactSet = srampQuery.executeQuery();
            if (artifactSet.iterator().hasNext()) {
                BaseArtifactType baseArtifact = (BaseArtifactType)artifactSet.iterator().next();
                String assetsString = "";
                for (Property property : baseArtifact.getProperty()) {
                    if (!"AssetInfoXML".equals(property.getPropertyName())) continue;
                    assetsString = property.getPropertyValue();
                    break;
                }
                if (assetsString.length() > 0) {
                    JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.overlord.sramp.atom.services.brms");
                    Unmarshaller unMarshaller = jaxbContext.createUnmarshaller();
                    StringReader reader = new StringReader(assetsString);
                    JAXBElement element = unMarshaller.unmarshal((Source)new StreamSource(reader), Assets.class);
                    assets = (Assets)element.getValue();
                }
            }
            return assets;
        }
        catch (Throwable e) {
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="rest/packages/{pkgName}/assets/{assetName}")
    @Produces(value={"application/atom+xml;type=entry", "application/atom+xml"})
    public Entry getRestXMLAsset(@PathParam(value="pkgName") String pkgName, @PathParam(value="assetName") String assetName) throws SrampAtomException {
        try {
            pkgName = pkgName + ".pkg";
            QueryManager queryManager = QueryManagerFactory.newInstance();
            String query = String.format("/s-ramp/%1$s/%2$s[@name='%3$s']", "ext", "BrmsPkgDocument", pkgName);
            SrampQuery srampQuery = queryManager.createQuery(query, "name", true);
            ArtifactSet artifactSet = srampQuery.executeQuery();
            if (artifactSet.iterator().hasNext()) {
                BaseArtifactType baseArtifact = (BaseArtifactType)artifactSet.iterator().next();
                String assetsString = "";
                for (Property property : baseArtifact.getProperty()) {
                    if (!"AssetInfoXML".equals(property.getPropertyName())) continue;
                    assetsString = property.getPropertyValue();
                    break;
                }
                if (assetsString.length() > 0) {
                    JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.overlord.sramp.atom.services.brms");
                    Unmarshaller unMarshaller = jaxbContext.createUnmarshaller();
                    StringReader reader = new StringReader(assetsString);
                    JAXBElement element = unMarshaller.unmarshal((Source)new StreamSource(reader), Assets.class);
                    Assets assets = (Assets)element.getValue();
                    for (Assets.Asset asset : assets.getAsset()) {
                        if (!asset.getTitle().equals(assetName)) continue;
                        Entry entry = new Entry();
                        entry.setBase(new URI(asset.getRefLink()));
                        entry.setTitle(asset.getTitle());
                        entry.setId(new URI(asset.getRefLink()));
                        entry.setPublished(asset.getPublished().toGregorianCalendar().getTime());
                        entry.getContributors().add(new Person(asset.getAuthor()));
                        Content content = new Content();
                        content.setType(MediaType.APPLICATION_OCTET_STREAM_TYPE);
                        content.setBase(new URI(asset.getBinaryLink()));
                        entry.setContent(content);
                        Format format = new Format();
                        format.setValue(asset.getMetadata().getFormat());
                        entry.setAnyOtherJAXBObject((Object)format);
                        return entry;
                    }
                }
            }
            return null;
        }
        catch (Throwable e) {
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="/org.drools.guvnor.Guvnor/package/{pkgName}/{version}")
    public Response getDroolsPackage(@PathParam(value="pkgName") String pkgName, @PathParam(value="version") String version) throws SrampAtomException {
        try {
            return this.getRestPackage(pkgName);
        }
        catch (Throwable e) {
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="rest/packages/{pkgName}/binary")
    public Response getRestPackage(@PathParam(value="pkgName") String pkgName) throws SrampAtomException {
        try {
            pkgName = pkgName + ".pkg";
            QueryManager queryManager = QueryManagerFactory.newInstance();
            String query = String.format("/s-ramp/%1$s/%2$s[@name='%3$s']", "ext", "BrmsPkgDocument", pkgName);
            SrampQuery srampQuery = queryManager.createQuery(query, "name", true);
            ArtifactSet artifactSet = srampQuery.executeQuery();
            if (artifactSet.iterator().hasNext()) {
                BaseArtifactType baseArtifact = (BaseArtifactType)artifactSet.iterator().next();
                PersistenceManager persistenceManager = PersistenceFactory.newInstance();
                ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactEnum)baseArtifact.getArtifactType());
                artifactType.setExtendedType("BrmsPkgDocument");
                InputStream artifactContent = persistenceManager.getArtifactContent(baseArtifact.getUuid(), artifactType);
                1 output = new /* Unavailable Anonymous Inner Class!! */;
                String lastModifiedDate = this.simpleDateFormat.format(baseArtifact.getLastModifiedTimestamp().toGregorianCalendar().getTime());
                return Response.ok((Object)output, (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=" + baseArtifact.getName())).header("Content-Length", baseArtifact.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)).header("Last-Modified", (Object)lastModifiedDate).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Throwable e) {
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="org.drools.guvnor.Guvnor/package/{pkgName}/{version}/{fileName}")
    public Response getDroolsFile(@PathParam(value="pkgName") String pkgName, @PathParam(value="version") String version, @PathParam(value="fileName") String fileName) throws SrampAtomException {
        String assetName = fileName;
        if (fileName.contains(".")) {
            assetName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        return this.getRestAsset("application/octet-stream", pkgName, assetName);
    }

    @GET
    @Produces(value={"application/atom+xml", "application/octet-stream"})
    @Path(value="rest/packages/{pkgName}/assets/{assetName}/binary")
    public Response getRestAsset(@HeaderParam(value="Accept") String accept, @PathParam(value="pkgName") String pkgName, @PathParam(value="assetName") String assetName) throws SrampAtomException {
        try {
            Assets assets = this.getRestXMLAllAssetsInPackage(pkgName);
            String uuid = null;
            String format = null;
            for (Assets.Asset asset : assets.getAsset()) {
                if (!asset.getTitle().equals(assetName)) continue;
                uuid = asset.getMetadata().getUuid();
                format = asset.getMetadata().getFormat();
                break;
            }
            if (uuid != null) {
                ArtifactType artifactType = ArtifactType.fromFileExtension(format);
                PersistenceManager persistenceManager = PersistenceFactory.newInstance();
                BaseArtifactType baseArtifact = persistenceManager.getArtifact(uuid, artifactType);
                InputStream artifactContent = persistenceManager.getArtifactContent(uuid, artifactType);
                2 output = new /* Unavailable Anonymous Inner Class!! */;
                String lastModifiedDate = this.simpleDateFormat.format(baseArtifact.getLastModifiedTimestamp().toGregorianCalendar().getTime());
                if (accept != null && (accept.contains("application/atom+xml") || accept.contains("application/xml"))) {
                    return Response.ok((Object)output, (String)"application/xml").header("Content-Length", baseArtifact.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)).header("Last-Modified", (Object)lastModifiedDate).build();
                }
                return Response.ok((Object)output, (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=" + baseArtifact.getName())).header("Content-Length", baseArtifact.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)).header("Last-Modified", (Object)lastModifiedDate).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Throwable e) {
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="rest/packages/{pkgName}/assets/{assetName}/source")
    public Response getRestSourceAsset(@PathParam(value="pkgName") String pkgName, @PathParam(value="assetName") String assetName) throws SrampAtomException {
        return this.getRestAsset("application/xml", pkgName, assetName);
    }
}

