/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.mappers;

import javax.xml.namespace.QName;
import org.overlord.sramp.common.ontology.SrampOntology;
import org.w3._1999._02._22_rdf_syntax_ns_.RDF;
import org.w3._2000._01.rdf_schema_.SubClassOf;
import org.w3._2002._07.owl_.Class;
import org.w3._2002._07.owl_.Ontology;

public class OntologyToRdfMapper {
    public void map(SrampOntology ontology, RDF rdf) {
        Ontology rdfOntology = new Ontology();
        rdfOntology.setID(ontology.getId());
        rdfOntology.setLabel(ontology.getLabel());
        rdfOntology.setComment(ontology.getComment());
        rdf.getOtherAttributes().put(new QName("http://www.w3.org/XML/1998/namespace", "base"), ontology.getBase());
        rdf.setOntology(rdfOntology);
        for (SrampOntology.Class oclass : ontology.getAllClasses()) {
            Class rdfClass = new Class();
            rdfClass.setID(oclass.getId());
            rdfClass.setLabel(oclass.getLabel());
            rdfClass.setComment(oclass.getComment());
            if (oclass.getParent() != null) {
                SubClassOf subclass = new SubClassOf();
                subclass.setResource(oclass.getParent().getUri().toString());
                rdfClass.setSubClassOf(subclass);
            }
            rdf.getClazz().add(rdfClass);
        }
    }
}

