/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.annotations.providers.multipart.PartType;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.multipart.MultipartOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactType;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.atom.beans.HttpResponseBean;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.visitors.ArtifactToFullAtomEntryVisitor;
import org.overlord.sramp.common.ArtifactNotFoundException;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.Sramp;
import org.overlord.sramp.common.SrampException;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.PersistenceManager;
import org.overlord.sramp.repository.errors.DerivedArtifactCreateException;
import org.overlord.sramp.server.atom.services.AbstractResource;
import org.overlord.sramp.server.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/s-ramp")
public class BatchResource
extends AbstractResource {
    private static Logger logger = LoggerFactory.getLogger(BatchResource.class);
    private final Sramp sramp = new Sramp();

    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"multipart/mixed"})
    @PartType(value="message/http")
    public MultipartOutput zipPackage(@Context HttpServletRequest request, @HeaderParam(value="Slug") String fileName, InputStream content) throws SrampAtomException {
        PersistenceManager persistenceManager = PersistenceFactory.newInstance();
        InputStream is = content;
        SrampArchive archive = null;
        String baseUrl = this.sramp.getBaseUrl(request.getRequestURL().toString());
        try {
            archive = new SrampArchive(content);
            MultipartOutput output = new MultipartOutput();
            output.setBoundary("package");
            Collection entries = archive.getEntries();
            ArrayList<PersistenceManager.BatchItem> createItems = new ArrayList<PersistenceManager.BatchItem>();
            ArrayList<SrampArchiveEntry> updates = new ArrayList<SrampArchiveEntry>();
            for (SrampArchiveEntry entry : entries) {
                String path = entry.getPath();
                String contentId = String.format("<%1$s@package>", path);
                BaseArtifactType metaData = entry.getMetaData();
                if (this.isCreate(metaData)) {
                    InputStream contentStream = BatchResource.ensureSupportsMark((InputStream)archive.getInputStream(entry));
                    ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)metaData);
                    if (artifactType.isDerived()) {
                        throw new DerivedArtifactCreateException(artifactType.getArtifactType());
                    }
                    String mimeType = MimeTypes.determineMimeType((String)metaData.getName(), (InputStream)contentStream, (ArtifactType)artifactType);
                    artifactType.setMimeType(mimeType);
                    if (metaData instanceof DocumentArtifactType) {
                        ((DocumentArtifactType)metaData).setContentType(mimeType);
                    }
                    PersistenceManager.BatchItem bi = new PersistenceManager.BatchItem(contentId, metaData, contentStream);
                    createItems.add(bi);
                    continue;
                }
                updates.add(entry);
            }
            List batchResponses = persistenceManager.persistBatch(createItems);
            for (int i = 0; i < createItems.size(); ++i) {
                PersistenceManager.BatchItem bi = (PersistenceManager.BatchItem)createItems.get(i);
                Object response = batchResponses.get(i);
                if (response instanceof BaseArtifactType) {
                    BaseArtifactType artifact = (BaseArtifactType)response;
                    ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
                    ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
                    Entry atomEntry = visitor.getAtomEntry();
                    this.addCreatedPart(output, bi.batchItemId, atomEntry);
                    continue;
                }
                if (!(response instanceof Exception)) continue;
                this.addErrorPart(output, bi.batchItemId, (Exception)response);
            }
            for (SrampArchiveEntry updateEntry : updates) {
                InputStream contentStream = BatchResource.ensureSupportsMark((InputStream)archive.getInputStream(updateEntry));
                String path = updateEntry.getPath();
                String contentId = String.format("<%1$s@package>", path);
                BaseArtifactType metaData = updateEntry.getMetaData();
                ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)metaData);
                Entry atomEntry = this.processUpdate(artifactType, metaData, contentStream, baseUrl);
                this.addUpdatedPart(output, contentId, atomEntry);
            }
            MultipartOutput multipartOutput = output;
            return multipartOutput;
        }
        catch (Exception e) {
            BatchResource.logError((Logger)logger, (String)"Error consuming S-RAMP batch zip package.", (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            if (archive != null) {
                SrampArchive.closeQuietly((SrampArchive)archive);
            }
        }
    }

    private boolean isCreate(BaseArtifactType metaData) {
        if (metaData.getUuid() == null) {
            return true;
        }
        return !this.artifactExists(metaData);
    }

    private boolean artifactExists(BaseArtifactType metaData) {
        try {
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)metaData);
            BaseArtifactType artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
            return artifact != null;
        }
        catch (SrampException e) {
            return false;
        }
    }

    private Entry processUpdate(ArtifactType artifactType, BaseArtifactType metaData, InputStream contentStream, String baseUrl) throws Exception {
        PersistenceManager persistenceManager = PersistenceFactory.newInstance();
        BaseArtifactType artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        if (artifact == null) {
            throw new ArtifactNotFoundException(metaData.getUuid());
        }
        persistenceManager.updateArtifact(metaData, artifactType);
        if (contentStream != null) {
            persistenceManager.updateArtifactContent(metaData.getUuid(), artifactType, contentStream);
        }
        artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        Entry atomEntry = visitor.getAtomEntry();
        return atomEntry;
    }

    private void addCreatedPart(MultipartOutput output, String contentId, Entry atomEntry) {
        HttpResponseBean createdResponse = new HttpResponseBean(201, "Created");
        createdResponse.setBody((Object)atomEntry, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_ENTRY_TYPE);
        output.addPart((Object)createdResponse, (javax.ws.rs.core.MediaType)MediaType.MESSAGE_HTTP_TYPE).getHeaders().putSingle((Object)"Content-ID", (Object)contentId);
    }

    private void addUpdatedPart(MultipartOutput output, String contentId, Entry atomEntry) {
        HttpResponseBean createdResponse = new HttpResponseBean(200, "OK");
        createdResponse.setBody((Object)atomEntry, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_ENTRY_TYPE);
        output.addPart((Object)createdResponse, (javax.ws.rs.core.MediaType)MediaType.MESSAGE_HTTP_TYPE).getHeaders().putSingle((Object)"Content-ID", (Object)contentId);
    }

    private void addErrorPart(MultipartOutput output, String contentId, Exception error) {
        HttpResponseBean errorResponse = new HttpResponseBean(409, "Conflict");
        SrampAtomException e = new SrampAtomException((Throwable)error);
        errorResponse.setBody((Object)e, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_SRAMP_ATOM_EXCEPTION_TYPE);
        output.addPart((Object)errorResponse, (javax.ws.rs.core.MediaType)MediaType.MESSAGE_HTTP_TYPE).getHeaders().putSingle((Object)"Content-ID", (Object)contentId);
    }
}

