/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.ArtifactTypeEnum;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.util.FileNameCompleter;
import org.overlord.sramp.shell.util.PrintArtifactMetaDataVisitor;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class UploadArtifactCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("s-ramp:upload <pathToArtifactContent> [<artifactType>]", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'upload' command uploads the content of a local file to", new Object[0]);
        this.print("the S-RAMP repository, creating a new artifact.  The artifact", new Object[0]);
        this.print("type can optionally be provided.  If excluded, the artifact", new Object[0]);
        this.print("type will be determined based on file extension.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usages:", new Object[0]);
        this.print(">  s-ramp:upload /home/uname/files/mytypes.xsd", new Object[0]);
        this.print(">  s-ramp:upload /home/uname/files/myservice.wsdl WsdlDocument", new Object[0]);
    }

    public void execute() throws Exception {
        String filePathArg = this.requiredArgument(0, "Please specify a path to a local file.");
        String artifactTypeArg = this.optionalArgument(1);
        QName clientVarName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print("No S-RAMP repository connection is currently open.", new Object[0]);
            return;
        }
        FileInputStream content = null;
        try {
            File file = new File(filePathArg);
            ArtifactType artifactType = null;
            artifactType = artifactTypeArg != null ? ArtifactType.valueOf((String)artifactTypeArg) : this.determineArtifactType(file);
            content = FileUtils.openInputStream((File)file);
            BaseArtifactType artifact = client.uploadArtifact(artifactType, (InputStream)content, file.getName());
            QName artifactVarName = new QName("s-ramp", "artifact");
            this.getContext().setVariable(artifactVarName, (Object)artifact);
            this.print("Successfully uploaded an artifact.", new Object[0]);
            PrintArtifactMetaDataVisitor visitor = new PrintArtifactMetaDataVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        }
        catch (Exception e) {
            this.print("FAILED to upload an artifact.", new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    private ArtifactType determineArtifactType(File file) {
        ArtifactType type = null;
        String extension = FilenameUtils.getExtension((String)file.getName());
        type = "wsdl".equals(extension) ? ArtifactType.WsdlDocument() : ("xsd".equals(extension) ? ArtifactType.XsdDocument() : ("wspolicy".equals(extension) ? ArtifactType.PolicyDocument() : ("xml".equals(extension) ? ArtifactType.XmlDocument() : ArtifactType.Document())));
        return type;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty()) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        if (this.getArguments().size() == 1) {
            for (ArtifactTypeEnum t : ArtifactTypeEnum.values()) {
                String candidate = t.getType();
                if (lastArgument != null && !candidate.startsWith(lastArgument)) continue;
                candidates.add(candidate);
            }
            return 0;
        }
        return -1;
    }
}

