/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.ontology;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.util.FileNameCompleter;

public class UploadOntologyCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("ontology:upload <pathToOntologyFile>", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'upload' command uploads a new OWL ontology file to the", new Object[0]);
        this.print("S-RAMP repository.  This makes the classes defined in the OWL", new Object[0]);
        this.print("ontology available for use as classifications on artifacts.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print(">  ontology:upload /home/uname/files/regions.owl.xml", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        String filePathArg = this.requiredArgument(0, "Please specify a path to a local ontology file.");
        QName clientVarName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print("No S-RAMP repository connection is currently open.", new Object[0]);
            return;
        }
        FileInputStream content = null;
        try {
            File file = new File(filePathArg);
            content = FileUtils.openInputStream((File)file);
            client.uploadOntology((InputStream)content);
            this.print("Successfully uploaded a new ontology to the S-RAMP repository.", new Object[0]);
        }
        catch (Exception e) {
            try {
                this.print("FAILED to upload an artifact.", new Object[0]);
                this.print("\t" + e.getMessage(), new Object[0]);
                IOUtils.closeQuietly((InputStream)content);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(content);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)content);
        }
        IOUtils.closeQuietly((InputStream)content);
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (lastArgument == null) {
            lastArgument = "";
        }
        if (this.getArguments().isEmpty()) {
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return -1;
    }
}

