/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.Property;

public class PropertyCommand
extends AbstractShellCommand {
    private static final Set<String> CORE_PROPERTIES = new HashSet<String>();

    public PropertyCommand() {
        CORE_PROPERTIES.add("name");
        CORE_PROPERTIES.add("description");
        CORE_PROPERTIES.add("version");
    }

    public void printUsage() {
        this.print("s-ramp:property <subCommand> <subCommandArguments>", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'property' command manipulates the properties of the currently", new Object[0]);
        this.print("active S-RAMP artifact.  The artifact must first be in the current", new Object[0]);
        this.print("session through the s-ramp:getMetaData command.  This command sets", new Object[0]);
        this.print("or unsets properties on that active artifact.  Both core meta-data", new Object[0]);
        this.print("properties and custom (user-defined) properties can be manipulated", new Object[0]);
        this.print("using this command.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Supported sub-commands:  set, unset", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print(">  s-ramp:property set name MyArtifactName", new Object[0]);
        this.print(">  s-ramp:property set customProp customVal", new Object[0]);
        this.print(">  s-ramp:property unset customProp", new Object[0]);
    }

    public void execute() throws Exception {
        block7: {
            String subcmdArg = this.requiredArgument(0, "Please specify a sub-command (set, unset).");
            String propNameArg = this.requiredArgument(1, "Please specify a property name.");
            String propValueArg = null;
            if ("set".equals(subcmdArg)) {
                propValueArg = this.requiredArgument(2, "Please specify a property value.");
            }
            QName artifactVarName = new QName("s-ramp", "artifact");
            BaseArtifactType artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName);
            if (artifact == null) {
                this.print("No active S-RAMP artifact exists.  Use s-ramp:getMetaData.", new Object[0]);
                return;
            }
            try {
                if ("set".equals(subcmdArg)) {
                    this.setProperty(artifact, propNameArg, propValueArg);
                    this.print("Successfully set property %1$s.", new Object[]{propNameArg});
                    break block7;
                }
                if ("unset".equals(subcmdArg)) {
                    this.unsetProperty(artifact, propNameArg);
                    this.print("Successfully unset property %1$s.", new Object[]{propNameArg});
                    break block7;
                }
                throw new InvalidCommandArgumentException(0, "Invalid sub-command, must be either 'set' or 'unset'.");
            }
            catch (InvalidCommandArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                this.print("FAILED to change the artifact property.", new Object[0]);
                this.print("\t" + e.getMessage(), new Object[0]);
            }
        }
    }

    private void setProperty(BaseArtifactType artifact, String propName, String propValue) {
        String propNameLC = propName.toLowerCase();
        if (CORE_PROPERTIES.contains(propNameLC)) {
            if (propNameLC.equals("name")) {
                artifact.setName(propValue);
            } else if (propNameLC.equals("description")) {
                artifact.setDescription(propValue);
            } else if (propNameLC.equals("version")) {
                artifact.setVersion(propValue);
            }
        } else {
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)propName, (String)propValue);
        }
    }

    private void unsetProperty(BaseArtifactType artifact, String propName) {
        this.setProperty(artifact, propName, null);
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        BaseArtifactType artifact;
        QName artifactVarName = new QName("s-ramp", "artifact");
        if (this.getArguments().isEmpty()) {
            if (lastArgument == null) {
                candidates.add("set ");
                candidates.add("unset ");
                return 0;
            }
            if ("set".startsWith(lastArgument)) {
                candidates.add("set ");
                return 0;
            }
            if ("unset".startsWith(lastArgument)) {
                candidates.add("unset ");
                return 0;
            }
        } else if (this.getArguments().size() == 1 && (this.getArguments().contains((Object)"set") || this.getArguments().contains((Object)"unset")) && (artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName)) != null) {
            TreeSet<String> props = new TreeSet<String>();
            props.addAll(CORE_PROPERTIES);
            props.addAll(this.getCustomPropertyNames(artifact));
            String candidatePostfix = " ";
            if (this.getArguments().contains((Object)"unset")) {
                candidatePostfix = "";
            }
            for (String prop : props) {
                if (lastArgument != null && !prop.startsWith(lastArgument)) continue;
                candidates.add(prop + candidatePostfix);
            }
            return 0;
        }
        return -1;
    }

    private Collection<String> getCustomPropertyNames(BaseArtifactType artifact) {
        HashSet<String> props = new HashSet<String>();
        for (Property prop : artifact.getProperty()) {
            props.add(prop.getPropertyName());
        }
        return props;
    }
}

