/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import javax.xml.namespace.QName;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class StatusCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("s-ramp:status", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'status' command displays the current S-RAMP status.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print(">  s-ramp:status", new Object[0]);
    }

    public void execute() throws Exception {
        QName clientVarName = new QName("s-ramp", "client");
        QName artifactVarName = new QName("s-ramp", "artifact");
        QName feedVarName = new QName("s-ramp", "feed");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        BaseArtifactType artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName);
        QueryResultSet feed = (QueryResultSet)this.getContext().getVariable(feedVarName);
        if (client == null) {
            this.print(" S-RAMP Connection: <not currently connected>", new Object[0]);
        } else {
            this.print(" S-RAMP Connection: %1$s", new Object[]{client.getEndpoint()});
        }
        if (artifact == null) {
            this.print("   S-RAMP Artifact: <none currently active>", new Object[0]);
        } else {
            ArtifactType type = ArtifactType.valueOf((BaseArtifactType)artifact);
            this.print("   S-RAMP Artifact: %1$s (%2$s)", new Object[]{artifact.getName(), type.getType()});
        }
        if (feed == null) {
            this.print("     Artifact Feed: <none currently active>", new Object[0]);
        } else {
            this.print("     Artifact Feed: %1$d items", new Object[]{feed.size()});
        }
    }
}

