/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import javax.xml.namespace.QName;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class UpdateMetaDataCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("s-ramp:updateMetaData", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'updateMetaData' command updates the meta-data of the currently active", new Object[0]);
        this.print("artifact in the context.  Whatever changes were made to the active", new Object[0]);
        this.print("artifact will be sent back to the S-RAMP repository.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print(">  s-ramp:updateMetaData", new Object[0]);
    }

    public void execute() throws Exception {
        QName clientVarName = new QName("s-ramp", "client");
        QName artifactVarName = new QName("s-ramp", "artifact");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print("No S-RAMP repository connection is currently open.", new Object[0]);
            return;
        }
        BaseArtifactType artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName);
        if (artifact == null) {
            this.print("No active S-RAMP artifact exists.  Use s-ramp:getMetaData.", new Object[0]);
            return;
        }
        try {
            client.updateArtifactMetaData(artifact);
            this.print("Successfully updated artifact %1$s.", new Object[]{artifact.getName()});
        }
        catch (Exception e) {
            this.print("FAILED to update the artifact.", new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
        }
    }
}

