/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.shell.AbstractShellCommandReader;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.ShellContextImpl;

public class FileShellCommandReader
extends AbstractShellCommandReader {
    private String filePath;
    private BufferedReader fileReader;

    public FileShellCommandReader(ShellCommandFactory factory, ShellContextImpl context, String filePath) {
        super(factory, context);
        this.filePath = filePath;
    }

    @Override
    public void open() throws IOException {
        File file = new File(this.filePath);
        if (!file.isFile()) {
            throw new FileNotFoundException(this.filePath);
        }
        this.fileReader = new BufferedReader(new InputStreamReader(FileUtils.openInputStream((File)file)));
    }

    @Override
    protected String readLine() throws IOException {
        String line = null;
        while ((line = this.fileReader.readLine()) != null && (line.startsWith("#") || line.trim().length() == 0)) {
        }
        return line;
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Reader)this.fileReader);
    }
}

