/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.audit;

import java.util.List;
import javax.xml.namespace.QName;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.audit.AuditEntrySummary;
import org.overlord.sramp.client.audit.AuditResultSet;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;

public class ShowAuditTrailCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("audit:showAuditTrail <artifactId>", new Object[0]);
        this.print("\tValid formats for artifactId:", new Object[0]);
        this.print("\t  feed:<feedIndex> - an index into the most recent feed", new Object[0]);
        this.print("\t  uuid:<srampUUID> - the UUID of an s-ramp artifact", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'showAuditTrail' command displays a list of all the audit", new Object[0]);
        this.print("entries for a given artifact.  Use this command to see how an", new Object[0]);
        this.print("artifact has been modified over time.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print("> audit:showAuditTrail feed:3", new Object[0]);
        this.print("> audit:showAuditTrail uuid:7387-28732-9183-92737", new Object[0]);
    }

    public void execute() throws Exception {
        int feedIdx;
        QueryResultSet rset;
        String artifactIdArg = this.requiredArgument(0, "Please specify a valid artifact identifier.");
        if (!artifactIdArg.contains(":")) {
            throw new InvalidCommandArgumentException(0, "Invalid artifact id format.");
        }
        QName clientVarName = new QName("s-ramp", "client");
        QName feedVarName = new QName("s-ramp", "feed");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print("No S-RAMP repository connection is currently open.", new Object[0]);
            return;
        }
        String artifactUuid = null;
        String idType = artifactIdArg.substring(0, artifactIdArg.indexOf(58));
        if ("feed".equals(idType)) {
            rset = (QueryResultSet)this.getContext().getVariable(feedVarName);
            feedIdx = Integer.parseInt(artifactIdArg.substring(artifactIdArg.indexOf(58) + 1)) - 1;
            if (feedIdx < 0 || (long)feedIdx >= rset.size()) {
                throw new InvalidCommandArgumentException(0, "Feed index out of range.");
            }
        } else {
            if ("uuid".equals(idType)) {
                throw new InvalidCommandArgumentException(0, "uuid: style artifact identifiers not yet implemented.");
            }
            throw new InvalidCommandArgumentException(0, "Invalid artifact id format.");
        }
        ArtifactSummary summary = rset.get(feedIdx);
        artifactUuid = summary.getUuid();
        AuditResultSet auditTrail = client.getAuditTrailForArtifact(artifactUuid);
        QName artifactVarName = new QName("audit", "auditTrail");
        this.getContext().setVariable(artifactVarName, (Object)auditTrail);
        this.print("Artifact Audit Trail (%1$d entries)", new Object[]{auditTrail.size()});
        this.print("  Idx  Audit Entry", new Object[0]);
        this.print("  ---  -----------", new Object[0]);
        int idx = 1;
        for (AuditEntrySummary auditEntrySummary : auditTrail) {
            this.print("  %1$3d  %2$s", new Object[]{idx++, auditEntrySummary.toString()});
        }
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty() && (lastArgument == null || "feed:".startsWith(lastArgument))) {
            QName feedVarName = new QName("s-ramp", "feed");
            QueryResultSet rset = (QueryResultSet)this.getContext().getVariable(feedVarName);
            if (rset != null) {
                int idx = 0;
                while ((long)idx < rset.size()) {
                    String candidate = "feed:" + (idx + 1);
                    if (lastArgument == null) {
                        candidates.add(candidate);
                    }
                    if (lastArgument != null && candidate.startsWith(lastArgument)) {
                        candidates.add(candidate);
                    }
                    ++idx;
                }
            }
            return 0;
        }
        return -1;
    }
}

