/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.i18n.Messages;

public class AddEntryArchiveCommand
extends BuiltInShellCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws Exception {
        String archivePathArg = this.requiredArgument(0, Messages.i18n.format("InvalidArgMsg.EntryPath", new Object[0]));
        String artifactTypeArg = this.requiredArgument(1, Messages.i18n.format("AddEntry.InvalidArgMsg.ArtifactType", new Object[0]));
        String pathToContent = this.optionalArgument(2);
        QName varName = new QName("archive", "active-archive");
        SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive == null) {
            this.print(Messages.i18n.format("NO_ARCHIVE_OPEN", new Object[0]), new Object[0]);
            return false;
        }
        FileInputStream contentStream = null;
        try {
            ArtifactType type = ArtifactType.valueOf((String)artifactTypeArg);
            String name = new File(archivePathArg).getName();
            if (pathToContent != null) {
                File contentFile = new File(pathToContent);
                contentStream = FileUtils.openInputStream((File)contentFile);
            }
            BaseArtifactType artifact = type.newArtifactInstance();
            artifact.setName(name);
            archive.addEntry(archivePathArg, artifact, (InputStream)contentStream);
            this.print(Messages.i18n.format("AddEntry.Added", new Object[]{archivePathArg}), new Object[0]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(contentStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)contentStream);
        return true;
    }
}

