/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.ShellCommandReader;
import org.overlord.sramp.shell.api.Arguments;
import org.overlord.sramp.shell.api.ShellCommand;
import org.overlord.sramp.shell.api.ShellContext;
import org.overlord.sramp.shell.commands.NoOpCommand;

public abstract class AbstractShellCommandReader
implements ShellCommandReader {
    private final ShellContext context;
    private final ShellCommandFactory factory;
    private Map<String, String> properties;

    public AbstractShellCommandReader(ShellCommandFactory factory, ShellContext context) {
        this.factory = factory;
        this.context = context;
    }

    public AbstractShellCommandReader(ShellCommandFactory factory, ShellContext context, Map<String, String> properties) {
        this.factory = factory;
        this.context = context;
        this.properties = properties;
    }

    @Override
    public abstract void open() throws IOException;

    @Override
    public final ShellCommand read() throws Exception {
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        Arguments arguments = new Arguments(line = AbstractShellCommandReader.filterLine(line, this.properties));
        if (arguments.isEmpty()) {
            return new NoOpCommand();
        }
        QName commandName = arguments.removeCommandName();
        ShellCommand command = this.factory.createCommand(commandName);
        command.setContext(this.context);
        command.setArguments(arguments);
        command.setOutput(this.getCommandOutput());
        return command;
    }

    protected static String filterLine(String line, Map<String, String> properties) {
        String filtered = line;
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            String match = matcher.group();
            String key = match.substring(2, match.length() - 1);
            if (properties.containsKey(key)) {
                filtered = filtered.replace(match, properties.get(key));
                continue;
            }
            if (!System.getProperties().containsKey(key)) continue;
            filtered = filtered.replace(match, (String)System.getProperties().get(key));
        }
        return filtered;
    }

    protected Writer getCommandOutput() {
        return new OutputStreamWriter(System.out);
    }

    protected abstract String readLine() throws IOException;

    @Override
    public void close() throws IOException {
    }

    public ShellCommandFactory getFactory() {
        return this.factory;
    }

    public ShellContext getContext() {
        return this.context;
    }

    @Override
    public boolean isBatch() {
        return false;
    }
}

