/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import javax.xml.namespace.QName;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.i18n.Messages;

public class CreateArtifactCommand
extends BuiltInShellCommand {
    private SrampAtomApiClient client;

    public boolean execute() throws Exception {
        String artifactTypeArg = this.requiredArgument(0, Messages.i18n.format("ArtifactModel.Mandatory", new Object[0]));
        String nameArg = this.requiredArgument(1, Messages.i18n.format("ArtifactName.Mandatory", new Object[0]));
        String descriptionArg = this.optionalArgument(2);
        QName clientVarName = new QName("s-ramp", "client");
        this.client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (this.client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        ArtifactType artifactType = ArtifactType.valueOf((String)artifactTypeArg);
        if (artifactType.isExtendedType()) {
            artifactType = ArtifactType.ExtendedArtifactType((String)artifactType.getExtendedType(), (boolean)false);
        }
        if (artifactType.isDerived()) {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("ArtifactModel.isDerived", new Object[0]));
        }
        if (artifactType.isDocument()) {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("ArtifactModel.isDocument", new Object[0]));
        }
        BaseArtifactType artifact = artifactType.newArtifactInstance();
        artifact.setName(nameArg);
        artifact.setDescription(descriptionArg);
        artifact = this.client.createArtifact(artifact);
        QName artifactVarName = new QName("s-ramp", "artifact");
        this.getContext().setVariable(artifactVarName, (Object)artifact);
        this.print(Messages.i18n.format("CreateArtifactCommand.Successful", new Object[]{nameArg}), new Object[0]);
        return true;
    }
}

