/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleOutput;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.settings.Settings;
import org.overlord.sramp.shell.AbstractShellCommandReader;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.ShellContextImpl;
import org.overlord.sramp.shell.TabCompleter;
import org.overlord.sramp.shell.api.ShellContextEventHandler;

public class InteractiveShellCommandReader
extends AbstractShellCommandReader
implements ShellContextEventHandler {
    private static final QName CLIENT_NAME = new QName("s-ramp", "client");
    private Console consoleReader;
    private Prompt prompt;

    public InteractiveShellCommandReader(ShellCommandFactory factory, ShellContextImpl context) {
        super(factory, context);
        context.addHandler(this);
    }

    @Override
    public void open() throws IOException {
        Settings settings = Settings.getInstance();
        settings.setAliasEnabled(false);
        settings.setEnablePipelineAndRedirectionParser(false);
        settings.setLogging(true);
        this.consoleReader = new Console(settings);
        String promptChar = this.defaultAnsiPrompt();
        this.prompt = new Prompt(promptChar);
        this.consoleReader.addCompletion((Completion)new TabCompleter(this.getFactory(), this.getContext()));
    }

    private String defaultAnsiPrompt() {
        return "\u001b[1m\u001b[31ms-ramp>\u001b[0m ";
    }

    private String connectedAnsiPrompt() {
        return "\u001b[1m\u001b[32ms-ramp>\u001b[0m ";
    }

    @Override
    protected String readLine() throws IOException {
        ConsoleOutput output;
        if (this.consoleReader.isRunning() && (output = this.consoleReader.read(this.prompt, null)) != null) {
            return output.getBuffer();
        }
        return "";
    }

    @Override
    protected Writer getCommandOutput() {
        return new OutputStreamWriter(Settings.getInstance().getStdOut());
    }

    @Override
    public void close() throws IOException {
        this.consoleReader.stop();
    }

    public void onVariableAdded(QName variableName, Object value) {
        if (CLIENT_NAME.equals(variableName)) {
            this.prompt = new Prompt(this.connectedAnsiPrompt());
        }
    }

    public void onVariableChanged(QName variableName, Object value) {
    }

    public void onVariableRemoved(QName variableName) {
        if (CLIENT_NAME.equals(variableName)) {
            this.prompt = new Prompt(this.defaultAnsiPrompt());
        }
    }

    @Override
    public String promptForInput(String promptString) {
        String oldprompt = this.prompt.getPromptAsString();
        try {
            String string = this.consoleReader.read(promptString).getBuffer();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.prompt = new Prompt(oldprompt);
        }
    }

    @Override
    public String promptForPassword(String promptString) {
        String oldprompt = this.prompt.getPromptAsString();
        try {
            Prompt newPrompt = new Prompt(promptString);
            String string = this.consoleReader.read(newPrompt, Character.valueOf('\u0000')).getBuffer();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.prompt = new Prompt(oldprompt);
        }
    }
}

