/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.ontology;

import java.util.List;
import javax.xml.namespace.QName;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.ontology.OntologySummary;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.commands.ontology.FeedTabCompleter;
import org.overlord.sramp.shell.i18n.Messages;

public class DeleteOntologyCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String ontologyIdArg = this.requiredArgument(0, Messages.i18n.format("DeleteOntology.InvalidArgMsg.OntologyId", new Object[0]));
        QName feedVarName = new QName("ontology", "feed");
        QName clientVarName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        if (!ontologyIdArg.contains(":") || ontologyIdArg.endsWith(":")) {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("InvalidOntologyIdFormat", new Object[0]));
        }
        String ontologyUuid = null;
        int colonIdx = ontologyIdArg.indexOf(58);
        String idType = ontologyIdArg.substring(0, colonIdx);
        String idValue = ontologyIdArg.substring(colonIdx + 1);
        if ("feed".equals(idType)) {
            List ontologies = (List)this.getContext().getVariable(feedVarName);
            if (ontologies == null) {
                throw new InvalidCommandArgumentException(0, Messages.i18n.format("DeleteOntology.NoOntologyFeed", new Object[0]));
            }
            int feedIdx = Integer.parseInt(idValue) - 1;
            if (feedIdx < 0 || feedIdx >= ontologies.size()) {
                throw new InvalidCommandArgumentException(0, Messages.i18n.format("FeedIndexOutOfRange", new Object[0]));
            }
            OntologySummary summary = (OntologySummary)ontologies.get(feedIdx);
            ontologyUuid = summary.getUuid();
        } else if ("uuid".equals(idType)) {
            ontologyUuid = idValue;
        } else {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("InvalidIdFormat", new Object[0]));
        }
        try {
            client.deleteOntology(ontologyUuid);
            this.print(Messages.i18n.format("DeleteOntology.Deleted", new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("DeleteOntology.DeleteFailed", new Object[0]), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        return FeedTabCompleter.tabCompletion(this.getArguments(), this.getContext(), lastArgument, candidates);
    }
}

