/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.util.Locale;
import org.overlord.sramp.shell.AbstractSrampShell;
import org.overlord.sramp.shell.i18n.Messages;

public class SrampShell
extends AbstractSrampShell {
    public static void main(String[] args) {
        String locale_str = System.getProperty("s-ramp.shell.locale");
        if (locale_str != null) {
            String lang = null;
            String region = null;
            String[] lsplit = locale_str.split("_");
            if (lsplit.length > 0) {
                lang = lsplit[0];
            }
            if (lsplit.length > 1) {
                region = lsplit[1];
            }
            if (lang != null && region != null) {
                Locale.setDefault(new Locale(lang, region));
            } else if (lang != null) {
                Locale.setDefault(new Locale(lang));
            }
        }
        final SrampShell shell = new SrampShell();
        Thread shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                shell.shutdown();
            }
        });
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        try {
            shell.run(args);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.out.println(Messages.i18n.format("Shell.EXITING", new Object[0]));
        }
    }

    @Override
    protected void exit() {
        System.exit(1);
    }
}

