/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.overlord.sramp.shell.commands.archive.AbstractArchiveCommand;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileNameCompleter;

public class PackArchiveCommand
extends AbstractArchiveCommand {
    public boolean execute() throws Exception {
        super.initialize();
        String outputLocationArg = this.requiredArgument(0, Messages.i18n.format("PackArchive.InvalidArgMsg.OutputLocation", new Object[0]));
        if (!this.validate(new String[0])) {
            return false;
        }
        File outputFile = new File(outputLocationArg);
        if (outputFile.exists()) {
            this.print(Messages.i18n.format("PackArchive.OutputLocAlreadyExists", new Object[0]), new Object[0]);
        }
        if (!outputFile.getParentFile().exists()) {
            outputFile.mkdirs();
        }
        File packedFile = this.archive.pack();
        FileUtils.copyFile((File)packedFile, (File)outputFile);
        this.print(Messages.i18n.format("PackArchive.Packaged", new Object[]{outputFile.getCanonicalPath()}), new Object[0]);
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (lastArgument == null) {
            lastArgument = "";
        }
        if (this.getArguments().isEmpty()) {
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return -1;
    }

    @Override
    protected boolean validate(String ... args) {
        return this.validateArchiveSession();
    }
}

