/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.storedquery;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.commands.storedquery.StoredQueryCommandUtil;
import org.overlord.sramp.shell.i18n.Messages;

public class UpdateStoredQueryCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String name = this.requiredArgument(0, Messages.i18n.format("StoredQuery.Name.Mandatory", new Object[0]));
        String query = this.requiredArgument(1, Messages.i18n.format("StoredQuery.Query.Mandatory", new Object[0]));
        String propertyNames = this.optionalArgument(2);
        SrampAtomApiClient client = StoredQueryCommandUtil.client(this, this.getContext());
        if (client == null) {
            return false;
        }
        StoredQuery storedQuery = new StoredQuery();
        storedQuery.setQueryName(name);
        storedQuery.setQueryExpression(query);
        if (StringUtils.isNotBlank((String)propertyNames)) {
            String[] split;
            for (String s : split = propertyNames.split(",")) {
                storedQuery.getPropertyName().add(s);
            }
        }
        try {
            client.updateStoredQuery(name, storedQuery);
            this.print(Messages.i18n.format("UpdateStoredQueryCommand.Success", new Object[]{name}), new Object[0]);
            return true;
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("UpdateStoredQueryCommand.Fail", new Object[]{name}), new Object[0]);
            return false;
        }
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        return StoredQueryCommandUtil.tabCompletion(this, this.getArguments(), this.getContext(), candidates);
    }
}

