/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.wagon.models;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.wagon.resource.Resource;

public class MavenGavInfo {
    private String fullName;
    private String name;
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String type;
    private boolean hash;
    private String hashAlgorithm;
    private boolean snapshot;
    private String snapshotId;
    private boolean mavenMetaData;

    public static MavenGavInfo fromResource(Resource resource) {
        String resourceName = resource.getName();
        ArrayList<String> segments = new ArrayList<String>(Arrays.asList(resourceName.split("/")));
        String filename = (String)segments.remove(segments.size() - 1);
        String type = filename.substring(filename.lastIndexOf(46) + 1);
        boolean hash = false;
        String hashAlgorithm = null;
        if (filename.endsWith(".sha1")) {
            type = filename.substring(0, filename.length() - 5);
            type = type.substring(type.lastIndexOf(46) + 1) + ".sha1";
            hash = true;
            hashAlgorithm = "SHA1";
        }
        if (filename.endsWith(".md5")) {
            type = filename.substring(0, filename.length() - 4);
            type = type.substring(type.lastIndexOf(46) + 1) + ".md5";
            hash = true;
            hashAlgorithm = "MD5";
        }
        String version = null;
        boolean metaData = filename.contains("maven-metadata.xml");
        if (metaData) {
            if (((String)segments.get(segments.size() - 1)).endsWith("-SNAPSHOT")) {
                version = (String)segments.remove(segments.size() - 1);
            }
        } else {
            version = (String)segments.remove(segments.size() - 1);
        }
        String artifactId = (String)segments.remove(segments.size() - 1);
        String groupId = StringUtils.join(segments, (String)".");
        String classifier = MavenGavInfo.extractClassifier(filename, version, type);
        boolean snapshot = version != null && version.endsWith("-SNAPSHOT");
        String snapshotId = null;
        if (snapshot && !metaData && !filename.contains(version)) {
            snapshotId = MavenGavInfo.extractSnapshotId(filename, version, type, classifier);
        }
        MavenGavInfo gav = new MavenGavInfo();
        gav.setFullName(resourceName);
        gav.setName(filename);
        gav.setGroupId(groupId);
        gav.setArtifactId(artifactId);
        gav.setVersion(version);
        gav.setClassifier(classifier);
        gav.setType(type);
        gav.setHash(hash);
        gav.setHashAlgorithm(hashAlgorithm);
        gav.setSnapshot(snapshot);
        gav.setSnapshotId(snapshotId);
        gav.setMavenMetaData(metaData);
        return gav;
    }

    private static String extractClassifier(String filename, String version, String type) {
        String[] split;
        String v2;
        int vidx;
        if (!filename.endsWith(type) || version == null) {
            return null;
        }
        String classifier = null;
        String w = filename;
        if ((w = w.substring(0, w.indexOf(type) - 1)).contains(version)) {
            int vidx2 = w.indexOf(version) + version.length();
            if (vidx2 < w.length() && (w = w.substring(vidx2)).startsWith("-")) {
                classifier = w.substring(1);
            }
        } else if (version.endsWith("-SNAPSHOT") && (vidx = w.indexOf(v2 = version.substring(0, version.indexOf("-SNAPSHOT"))) + v2.length() + 1) < w.length() && (split = (w = w.substring(vidx)).split("-")).length == 3) {
            classifier = split[2];
        }
        return classifier;
    }

    private static String extractSnapshotId(String filename, String version, String type, String classifier) {
        if (version == null) {
            return null;
        }
        String front = version.substring(0, version.indexOf("-SNAPSHOT"));
        String back = "." + type;
        if (classifier != null) {
            back = "-" + classifier + back;
        }
        int idx1 = filename.indexOf(front) + front.length() + 1;
        int idx2 = filename.indexOf(back);
        if (idx1 > 0 && idx1 < filename.length() && idx2 > 0 && idx2 < filename.length()) {
            return filename.substring(idx1, idx2);
        }
        return null;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append("\n");
        builder.append("  groupId: ");
        builder.append(this.getGroupId()).append("\n");
        builder.append("  artifactId: ");
        builder.append(this.getArtifactId()).append("\n");
        builder.append("  version: ");
        builder.append(this.getVersion()).append("\n");
        builder.append("  classifier: ");
        builder.append(this.getClassifier()).append("\n");
        builder.append("  type: ");
        builder.append(this.getType()).append("\n");
        builder.append("  isHash: ");
        builder.append(this.isHash()).append("\n");
        builder.append("  isSnapshot: ");
        builder.append(this.isSnapshot()).append("\n");
        builder.append("  isMavenMetaData: ");
        builder.append(this.isMavenMetaData()).append("\n");
        return builder.toString();
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isHash() {
        return this.hash;
    }

    public void setHash(boolean hash) {
        this.hash = hash;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public boolean isMavenMetaData() {
        return this.mavenMetaData;
    }

    public void setMavenMetaData(boolean mavenMetaData) {
        this.mavenMetaData = mavenMetaData;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }
}

