/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.CsrfValidator;
import org.owasp.csrfguard.http.InterceptRedirectResponse;
import org.owasp.csrfguard.session.LogicalSession;
import org.owasp.csrfguard.token.storage.LogicalSessionExtractor;
import org.owasp.csrfguard.token.transferobject.TokenTO;
import org.owasp.csrfguard.util.CsrfGuardUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsrfGuardFilter
implements Filter {
    private FilterConfig filterConfig = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(CsrfGuardFilter.class);

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        CsrfGuard csrfGuard = CsrfGuard.getInstance();
        if (csrfGuard.isEnabled()) {
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                if (CsrfGuardUtils.isPermittedUserAgent(httpServletRequest, httpServletResponse, csrfGuard)) {
                    this.doFilter(httpServletRequest, httpServletResponse, filterChain, csrfGuard);
                }
            } else {
                this.handleNonHttpServletMessages(request, response, filterChain);
            }
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public void destroy() {
        this.filterConfig = null;
    }

    private void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain, CsrfGuard csrfGuard) throws IOException, ServletException {
        InterceptRedirectResponse interceptRedirectResponse = new InterceptRedirectResponse(httpServletResponse, httpServletRequest, csrfGuard);
        LogicalSessionExtractor sessionKeyExtractor = csrfGuard.getLogicalSessionExtractor();
        LogicalSession logicalSession = sessionKeyExtractor.extract(httpServletRequest);
        if (logicalSession == null) {
            if (csrfGuard.isUseNewTokenLandingPage()) {
                LogicalSession createdLogicalSession = sessionKeyExtractor.extractOrCreate(httpServletRequest);
                csrfGuard.writeLandingPage((HttpServletResponse)interceptRedirectResponse, createdLogicalSession.getKey());
            } else {
                this.handleNoSession(httpServletRequest, httpServletResponse, interceptRedirectResponse, filterChain, csrfGuard);
            }
        } else {
            this.handleSession(httpServletRequest, interceptRedirectResponse, filterChain, logicalSession, csrfGuard);
        }
    }

    private void handleSession(HttpServletRequest httpServletRequest, InterceptRedirectResponse interceptRedirectResponse, FilterChain filterChain, LogicalSession logicalSession, CsrfGuard csrfGuard) throws IOException, ServletException {
        String logicalSessionKey = logicalSession.getKey();
        if (new CsrfValidator().isValid(httpServletRequest, (HttpServletResponse)interceptRedirectResponse)) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)interceptRedirectResponse);
        } else {
            this.logInvalidRequest(httpServletRequest);
        }
        String requestURI = httpServletRequest.getRequestURI();
        String generatedToken = csrfGuard.getTokenService().generateTokensIfAbsent(logicalSessionKey, httpServletRequest.getMethod(), requestURI);
        CsrfGuardUtils.addResponseTokenHeader(csrfGuard, httpServletRequest, (HttpServletResponse)interceptRedirectResponse, new TokenTO(Collections.singletonMap(requestURI, generatedToken)));
    }

    private void handleNoSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, InterceptRedirectResponse interceptRedirectResponse, FilterChain filterChain, CsrfGuard csrfGuard) throws IOException, ServletException {
        if (csrfGuard.isValidateWhenNoSessionExists()) {
            if (new CsrfValidator().isValid(httpServletRequest, (HttpServletResponse)interceptRedirectResponse)) {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)interceptRedirectResponse);
            } else {
                this.logInvalidRequest(httpServletRequest);
            }
        } else {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private void handleNonHttpServletMessages(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String message = String.format("CSRFGuard does not know how to work with requests of class %s ", request.getClass().getName());
        LOGGER.warn(message);
        this.filterConfig.getServletContext().log("[WARNING]" + message);
        filterChain.doFilter(request, response);
    }

    private void logInvalidRequest(HttpServletRequest httpRequest) {
        String requestURI = httpRequest.getRequestURI();
        String remoteAddress = httpRequest.getRemoteAddr();
        LOGGER.warn("Invalid request: URI: '{}' | Remote Address: '{}'", (Object)requestURI, (Object)remoteAddress);
    }
}

