/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;

public class Utils {
    public static String toSHA(String input) {
        return Utils.toSHA(input.getBytes());
    }

    public static String toSHA(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return Utils.byteArray2Hex(md.digest(input));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static String byteArray2Hex(byte[] hash) {
        try (Formatter formatter = new Formatter();){
            String hex;
            for (byte b : hash) {
                formatter.format("%02x", b);
            }
            String string = hex = formatter.toString();
            return string;
        }
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static String replaceCRLFWithUnderscore(String value) {
        return value.replace('\n', '_').replace('\r', '_');
    }

    public static String escapeNLFChars(String value) {
        return value.replace("\n", "\\n").replace("\r", "\\r").replace("\u0085", "\\u0085").replace("\u000b", "\\u000B").replace("\f", "\\u000C").replace("\u2028", "\\u2028").replace("\u2029", "\\u2029");
    }
}

