/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging.log4j.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.slf4j.Log4jMarker;
import org.apache.logging.slf4j.Log4jMarkerFactory;
import org.owasp.security.logging.SecurityMarkers;
import org.slf4j.Marker;

@Plugin(name="SecurityMarkerFilter", category="Core", elementType="filter", printObject=true)
public class SecurityMarkerFilter
extends AbstractFilter {
    private static final long serialVersionUID = 610457881503552839L;
    static final Log4jMarkerFactory factory = new Log4jMarkerFactory();
    public static final List<Marker> markersToMatch = new ArrayList<Marker>(3);

    public Filter.Result filter(Logger logger, Level level, org.apache.logging.log4j.Marker marker, String msg, Object ... params) {
        return this.filter(marker);
    }

    public Filter.Result filter(Logger logger, Level level, org.apache.logging.log4j.Marker marker, Object msg, Throwable t) {
        return this.filter(marker);
    }

    public Filter.Result filter(Logger logger, Level level, org.apache.logging.log4j.Marker marker, Message msg, Throwable t) {
        return this.filter(marker);
    }

    public Filter.Result filter(LogEvent event) {
        org.apache.logging.log4j.Marker eventMarker = event.getMarker();
        if (eventMarker == null) {
            return Filter.Result.DENY;
        }
        return this.filter(eventMarker);
    }

    private Filter.Result filter(org.apache.logging.log4j.Marker marker) {
        if (!this.isStarted()) {
            return Filter.Result.NEUTRAL;
        }
        Log4jMarker slf4jMarker = new Log4jMarker(marker);
        for (Marker matcher : markersToMatch) {
            if (!slf4jMarker.contains(matcher.getName())) continue;
            return Filter.Result.ACCEPT;
        }
        return Filter.Result.DENY;
    }

    @PluginFactory
    public static SecurityMarkerFilter createFilter(@PluginAttribute(value="acceptAll", defaultBoolean=false) boolean acceptAll) {
        return new SecurityMarkerFilter();
    }

    static {
        markersToMatch.add(SecurityMarkers.SECURITY_SUCCESS);
        markersToMatch.add(SecurityMarkers.SECURITY_FAILURE);
        markersToMatch.add(SecurityMarkers.SECURITY_AUDIT);
    }
}

