/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging.filter;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.AbstractMatcherFilter;
import ch.qos.logback.core.spi.FilterReply;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class MarkerFilter
extends AbstractMatcherFilter<ILoggingEvent> {
    Marker markerToMatch;

    public void start() {
        if (this.markerToMatch != null) {
            super.start();
        } else {
            this.addError(String.format("The marker property must be set for [%s]", this.getName()));
        }
    }

    public FilterReply decide(ILoggingEvent event) {
        Marker marker = event.getMarker();
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if (marker == null) {
            return this.onMismatch;
        }
        if (this.markerToMatch.contains(marker)) {
            return this.onMatch;
        }
        return this.onMismatch;
    }

    public void setMarker(String markerStr) {
        if (markerStr != null) {
            this.markerToMatch = MarkerFactory.getMarker((String)markerStr);
        }
    }
}

