/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.authenticator.test;

import java.util.Optional;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.DigestCredentials;

public class SimpleTestDigestAuthenticator
implements Authenticator {
    public Optional<Credentials> validate(CallContext ctx, Credentials cred) {
        if (cred == null) {
            throw new CredentialsException("No credential");
        }
        if (!(cred instanceof DigestCredentials)) {
            throw new CredentialsException("Unsupported credentials type " + cred.getClass());
        }
        DigestCredentials digestCredentials = (DigestCredentials)cred;
        String username = digestCredentials.getUsername();
        if (CommonHelper.isBlank((String)username)) {
            throw new CredentialsException("Username cannot be blank");
        }
        String token = digestCredentials.getToken();
        if (CommonHelper.isBlank((String)token)) {
            throw new CredentialsException("Token cannot be blank");
        }
        CommonProfile profile = new CommonProfile();
        profile.setId(username);
        digestCredentials.setUserProfile((UserProfile)profile);
        return Optional.of(digestCredentials);
    }
}

