/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.pantsbuild.jarjar.util.EntryStruct;
import org.pantsbuild.jarjar.util.JarProcessor;

public class MethodSignatureProcessor
implements JarProcessor {
    private static final Set<String> METHOD_NAMES_WITH_PARAMS_TO_REWRITE = new HashSet<String>(Arrays.asList("getImplMethodSignature"));
    private final Remapper remapper;

    public MethodSignatureProcessor(Remapper remapper) {
        this.remapper = remapper;
    }

    @Override
    public boolean process(EntryStruct entryStruct) throws IOException {
        ClassReader classReader;
        if (!entryStruct.name.endsWith(".class") || entryStruct.skipTransform) {
            return true;
        }
        ClassWriter classWriter = new ClassWriter(1);
        try {
            classReader = new ClassReader(entryStruct.data);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unable to read bytecode from " + entryStruct.name);
            runtimeException.printStackTrace();
            return true;
        }
        classReader.accept((ClassVisitor)new MethodSignatureRemapperClassVisitor((ClassVisitor)classWriter), 8);
        entryStruct.data = classWriter.toByteArray();
        return true;
    }

    private class MethodSignatureRemapperClassVisitor
    extends ClassVisitor {
        public MethodSignatureRemapperClassVisitor(ClassVisitor classVisitor) {
            super(458752, classVisitor);
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            return new MethodSignatureRemapperMethodVisitor(this.cv.visitMethod(n, string, string2, string3, stringArray));
        }

        private class MethodSignatureRemapperMethodVisitor
        extends MethodVisitor {
            private boolean rewriteNextLdcInstruction;

            private MethodSignatureRemapperMethodVisitor(MethodVisitor methodVisitor) {
                super(458752, methodVisitor);
                this.rewriteNextLdcInstruction = false;
            }

            private boolean shouldMarkNextLdcForRewrite(int n, String string) {
                return n == 182 && METHOD_NAMES_WITH_PARAMS_TO_REWRITE.contains(string);
            }

            public void visitMethodInsn(int n, String string, String string2, String string3) {
                this.rewriteNextLdcInstruction = this.shouldMarkNextLdcForRewrite(n, string2);
                this.mv.visitMethodInsn(n, string, string2, string3);
            }

            public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
                this.rewriteNextLdcInstruction = this.shouldMarkNextLdcForRewrite(n, string2);
                this.mv.visitMethodInsn(n, string, string2, string3, bl);
            }

            public void visitLdcInsn(Object object) {
                if (this.rewriteNextLdcInstruction && object instanceof String) {
                    this.rewriteNextLdcInstruction = false;
                    this.mv.visitLdcInsn((Object)MethodSignatureProcessor.this.remapper.mapSignature((String)object, false));
                } else {
                    this.mv.visitLdcInsn(object);
                }
            }
        }
    }
}

