/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.util.Iterator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

class RuleMethodRewriter
implements RuleMethodProcessor {
    private RuleMethod method;
    private InstructionGroup group;
    private int actionNr;
    private int varInitNr;

    RuleMethodRewriter() {
    }

    @Override
    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull((Object)((Object)parserClassNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)ruleMethod), (String)"method");
        return ruleMethod.containsExplicitActions() || ruleMethod.containsVars();
    }

    @Override
    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) throws Exception {
        this.method = (RuleMethod)((Object)Preconditions.checkArgNotNull((Object)((Object)ruleMethod), (String)"method"));
        this.actionNr = 0;
        this.varInitNr = 0;
        Iterator<InstructionGroup> iterator = ruleMethod.getGroups().iterator();
        while (iterator.hasNext()) {
            InstructionGroup instructionGroup;
            this.group = instructionGroup = iterator.next();
            this.createNewGroupClassInstance();
            this.initializeFields();
            InstructionGraphNode instructionGraphNode = instructionGroup.getRoot();
            if (instructionGraphNode.isActionRoot()) {
                this.removeGroupRootInstruction();
                continue;
            }
            ((MethodInsnNode)instructionGraphNode.getInstruction()).desc = "(L" + Types.FACTORY.getInternalName() + ";)V";
        }
        ruleMethod.setBodyRewritten();
    }

    private void createNewGroupClassInstance() {
        String string = this.group.getGroupClassType().getInternalName();
        InstructionGraphNode instructionGraphNode = this.group.getRoot();
        this.insert((AbstractInsnNode)new TypeInsnNode(187, string));
        this.insert((AbstractInsnNode)new InsnNode(89));
        this.insert((AbstractInsnNode)new LdcInsnNode((Object)(this.method.name + (instructionGraphNode.isActionRoot() ? "_Action" + ++this.actionNr : "_VarInit" + ++this.varInitNr))));
        this.insert((AbstractInsnNode)new MethodInsnNode(183, string, "<init>", "(Ljava/lang/String;)V", false));
        if (instructionGraphNode.isActionRoot() && this.method.hasSkipActionsInPredicatesAnnotation()) {
            this.insert((AbstractInsnNode)new InsnNode(89));
            this.insert((AbstractInsnNode)new MethodInsnNode(182, string, "setSkipInPredicates", "()V", false));
        }
    }

    private void initializeFields() {
        String string = this.group.getGroupClassType().getInternalName();
        for (FieldNode fieldNode : this.group.getFields()) {
            this.insert((AbstractInsnNode)new InsnNode(89));
            this.insert((AbstractInsnNode)new VarInsnNode(AsmUtils.getLoadingOpcode((Type)fieldNode.value), fieldNode.access));
            this.insert((AbstractInsnNode)new FieldInsnNode(181, string, fieldNode.name, fieldNode.desc));
        }
    }

    private void insert(AbstractInsnNode abstractInsnNode) {
        this.method.instructions.insertBefore(this.group.getRoot().getInstruction(), abstractInsnNode);
    }

    private void removeGroupRootInstruction() {
        this.method.instructions.remove(this.group.getRoot().getInstruction());
    }
}

