/*
 * Copyright 2009-2019 Mathias Doenitz
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.parboiled2.support

import shapeless._
import org.parboiled2.Rule
import shapeless.ops.hlist.Prepend

/*
 * The main ActionOps boilerplate is generated by a custom SBT sourceGenerator.
 * This file only contains support types.
 */

// we want to support the "short case class notation" `... ~> Foo`
// unfortunately the Tree for the function argument to the `apply` overloads above does *not* allow us to inspect the
// function type which is why we capture it separately with this helper type
sealed trait FCapture[T]

object FCapture {
  implicit def apply[T]: FCapture[T] = `n/a`
}

// builds `In` and `Out` types according to this logic:
//  if (R == Unit)
//    In = I, Out = L
//  else if (R <: HList)
//    In = I, Out = L ::: R
//  else if (R <: Rule[I2, O2])
//    In = TailSwitch[I2, L, I], Out = TailSwitch[L, I2, O2]
//  else
//    In = I, Out = L ::: R :: HNil
sealed trait Join[I <: HList, L <: HList, R] {
  type In <: HList
  type Out <: HList
}

object Join extends LowPrioJoin {

  implicit def forUnit[I <: HList, L <: HList]: Aux[I, L, Unit, I, L] = `n/a`

  implicit def forHList[I <: HList, L <: HList, R <: HList, O <: HList](
      implicit x: Prepend.Aux[L, R, O]
  ): Aux[I, L, R, I, O] = `n/a`

  implicit def forRule[I <: HList, O <: HList, I2 <: HList, O2 <: HList, In <: HList, Out <: HList](
      implicit i: TailSwitch.Aux[I2, I2, O, O, I, HNil, In],
      o: TailSwitch.Aux[O, O, I2, I2, O2, HNil, Out]
  ): Aux[I, O, Rule[I2, O2], In, Out] = `n/a`
}

sealed abstract class LowPrioJoin {

  type Aux[I <: HList, L <: HList, R, In0 <: HList, Out0 <: HList] =
    Join[I, L, R] { type In = In0; type Out = Out0 }

  implicit def forAny[I <: HList, L <: HList, R, In <: HList, Out <: HList](
      implicit x: Aux[I, L, R :: HNil, In, Out]
  ): Aux[I, L, R, In, Out] = `n/a`
}
