/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.customizations;

import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CEnumConstant;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.customizations.Customizations;
import org.jvnet.basicjaxb.util.ClassUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CustomizationsPlugin
extends AbstractParameterizablePlugin {
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private File directory;
    private boolean verbose;

    public CustomizationsPlugin() {
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File customizationsDirectory) {
        this.directory = customizationsDirectory;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getOptionName() {
        return "Xcustomizations";
    }

    public String getUsage() {
        return "  -Xcustomizations   :  reads and adds customizations from files";
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        if (this.getDirectory() == null) {
            this.logger.warn("Customizations directory is not provided, please use the -Xcustomizations-directory=<directory> command line argument to provide it.");
        } else if (!this.getDirectory().exists()) {
            this.logger.warn(MessageFormat.format("Customizations directory [{0}] does not exist.", this.getDirectory().getAbsolutePath()));
        } else if (!this.getDirectory().isDirectory()) {
            this.logger.warn(MessageFormat.format("Customizations directory [{0}] is not a directory.", this.getDirectory().getAbsolutePath()));
        } else {
            this.postProcessModel(model);
        }
    }

    private void postProcessModel(Model model) {
        for (CClassInfo classInfo : model.beans().values()) {
            this.postProcessClassInfo(model, classInfo);
        }
        for (CEnumLeafInfo enumLeafInfo : model.enums().values()) {
            this.postProcessEnumLeafInfo(model, enumLeafInfo);
        }
    }

    private void postProcessClassInfo(Model model, CClassInfo classInfo) {
        String packagedClassName = ClassUtils.getPackagedClassName((CClassInfo)classInfo);
        String customizationsFileName = packagedClassName.replace(".", "/") + ".xml";
        List<CPluginCustomization> customizations = this.readCustomizations(customizationsFileName);
        classInfo.getCustomizations().addAll(customizations);
        for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
            this.postProcessPropertyInfo(model, classInfo, propertyInfo);
        }
    }

    private void postProcessPropertyInfo(Model model, CClassInfo classInfo, CPropertyInfo propertyInfo) {
        String packagedClassName = ClassUtils.getPackagedClassName((CClassInfo)classInfo);
        String customizationsFileName = packagedClassName.replace(".", "/") + "." + propertyInfo.getName(false) + ".xml";
        List<CPluginCustomization> customizations = this.readCustomizations(customizationsFileName);
        propertyInfo.getCustomizations().addAll(customizations);
    }

    private void postProcessEnumLeafInfo(Model model, CEnumLeafInfo enumLeafInfo) {
        String packagedClassName = ClassUtils.getPackagedClassName((CEnumLeafInfo)enumLeafInfo);
        String customizationsFileName = packagedClassName.replace(".", "/") + ".xml";
        List<CPluginCustomization> customizations = this.readCustomizations(customizationsFileName);
        enumLeafInfo.getCustomizations().addAll(customizations);
        for (CEnumConstant enumConstant : enumLeafInfo.getConstants()) {
            this.postProcessEnumConstant(model, enumLeafInfo, enumConstant);
        }
    }

    private void postProcessEnumConstant(Model model, CEnumLeafInfo enumLeafInfo, CEnumConstant enumConstant) {
        String packagedClassName = ClassUtils.getPackagedClassName((CEnumLeafInfo)enumLeafInfo);
        String customizationsFileName = packagedClassName.replace(".", "/") + "." + enumConstant.getName() + ".xml";
        List<CPluginCustomization> customizations = this.readCustomizations(customizationsFileName);
        enumConstant.getCustomizations().addAll(customizations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CPluginCustomization> readCustomizations(String fileName) {
        LinkedList<CPluginCustomization> customizations = new LinkedList<CPluginCustomization>();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcex) {
            throw new UnsupportedOperationException("Could not created the DOM parser.", pcex);
        }
        File file = new File(this.getDirectory(), fileName);
        if (!file.exists()) {
            if (this.isVerbose()) {
                this.logger.debug(MessageFormat.format("File [{0}] does not exist.", file.getAbsolutePath()));
            }
        } else if (!file.isFile()) {
            this.logger.warn(MessageFormat.format("File [{0}] is not a file.", file.getAbsolutePath()));
        } else {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                Document document = documentBuilder.parse(is);
                Element documentElement = document.getDocumentElement();
                this.logger.debug(MessageFormat.format("Loaded customizations from [{0}].", file.getAbsolutePath()));
                QName documentElementName = new QName(documentElement.getNamespaceURI(), documentElement.getLocalName());
                if (Customizations.CUSTOMIZATIONS_ELEMENT_NAME.equals(documentElementName)) {
                    NodeList childNodes = documentElement.getChildNodes();
                    for (int index = 0; index < childNodes.getLength(); ++index) {
                        Node childNode = childNodes.item(index);
                        if (childNode.getNodeType() != 1) continue;
                        Element childElement = (Element)childNode;
                        customizations.add(new CPluginCustomization(childElement, null));
                    }
                } else {
                    customizations.add(new CPluginCustomization(documentElement, null));
                }
            }
            catch (IOException ioex) {
                this.logger.warn(MessageFormat.format("Could not parse [{0}].", file.getAbsolutePath()), (Throwable)ioex);
            }
            catch (SAXException saxex) {
                this.logger.warn(MessageFormat.format("Could not parse [{0}].", file.getAbsolutePath()), (Throwable)saxex);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException ioex) {}
                }
            }
        }
        return customizations;
    }
}

