/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.simplify;

import com.sun.codemodel.JJavaName;
import com.sun.tools.xjc.model.CAdapter;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassRef;
import com.sun.tools.xjc.model.CElement;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CNonElement;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CPropertyVisitor;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CTypeRef;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.model.Model;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.glassfish.jaxb.core.v2.model.core.ID;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.Customizations;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.util.CustomizationUtils;
import org.xml.sax.ErrorHandler;

public class SimplifyPlugin
extends AbstractParameterizablePlugin {
    private boolean usePluralForm = false;
    private Ignoring ignoring = new CustomizedIgnoring(org.jvnet.basicjaxb.plugin.simplify.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);

    public boolean isUsePluralForm() {
        return this.usePluralForm;
    }

    public void setUsePluralForm(boolean usePluralForm) {
        this.usePluralForm = usePluralForm;
    }

    public String getOptionName() {
        return "Xsimplify";
    }

    public String getUsage() {
        return "  -Xsimplify         :  simplifies 'choice' properties like fooOrBarOrBaz";
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(org.jvnet.basicjaxb.plugin.simplify.Customizations.PROPERTY_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.simplify.Customizations.AS_ELEMENT_PROPERTY_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.simplify.Customizations.AS_REFERENCE_PROPERTY_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.simplify.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        for (CClassInfo classInfo : model.beans().values()) {
            this.postProcessClassInfo(model, classInfo);
        }
    }

    private void postProcessClassInfo(final Model model, final CClassInfo classInfo) {
        ArrayList properties = new ArrayList(classInfo.getProperties());
        for (CPropertyInfo property : properties) {
            property.accept((CPropertyVisitor)new CPropertyVisitor<Void>(){

                public Void onElement(CElementPropertyInfo elementProperty) {
                    SimplifyPlugin.this.postProcessElementPropertyInfo(model, classInfo, elementProperty);
                    return null;
                }

                public Void onAttribute(CAttributePropertyInfo attributeProperty) {
                    return null;
                }

                public Void onValue(CValuePropertyInfo valueProperty) {
                    return null;
                }

                public Void onReference(CReferencePropertyInfo p) {
                    SimplifyPlugin.this.postProcessReferencePropertyInfo(model, classInfo, p);
                    return null;
                }
            });
        }
    }

    private void postProcessElementPropertyInfo(Model model, CClassInfo classInfo, CElementPropertyInfo property) {
        if (CustomizationUtils.containsPropertyCustomizationInPropertyOrClass((CPropertyInfo)property, (QName)org.jvnet.basicjaxb.plugin.simplify.Customizations.PROPERTY_ELEMENT_NAME, (QName)org.jvnet.basicjaxb.plugin.simplify.Customizations.AS_ELEMENT_PROPERTY_ELEMENT_NAME)) {
            this.simplifyElementPropertyInfoAsElementPropertyInfo(model, classInfo, property);
        }
    }

    private void postProcessReferencePropertyInfo(Model model, CClassInfo classInfo, CReferencePropertyInfo property) {
        if (CustomizationUtils.containsPropertyCustomizationInPropertyOrClass((CPropertyInfo)property, (QName)org.jvnet.basicjaxb.plugin.simplify.Customizations.PROPERTY_ELEMENT_NAME, (QName)org.jvnet.basicjaxb.plugin.simplify.Customizations.AS_ELEMENT_PROPERTY_ELEMENT_NAME)) {
            this.simplifyReferencePropertyInfoAsElementPropertyInfo(model, classInfo, property);
        } else if (CustomizationUtils.containsPropertyCustomizationInPropertyOrClass((CPropertyInfo)property, (QName)org.jvnet.basicjaxb.plugin.simplify.Customizations.PROPERTY_ELEMENT_NAME, (QName)org.jvnet.basicjaxb.plugin.simplify.Customizations.AS_REFERENCE_PROPERTY_ELEMENT_NAME)) {
            this.simplifyReferencePropertyInfoAsReferencePropertyInfo(model, classInfo, property);
        }
    }

    private void simplifyElementPropertyInfoAsElementPropertyInfo(Model model, CClassInfo classInfo, CElementPropertyInfo property) {
        if (property.getTypes().size() > 1) {
            this.logger.debug(MessageFormat.format("Element property [{0}] has several types and will be simplified.", property.getName(false)));
            int index = classInfo.getProperties().indexOf(property);
            for (CTypeRef typeRef : property.getTypes()) {
                CElementPropertyInfo elementPropertyInfo = this.createElementPropertyInfo(model, property, typeRef);
                classInfo.getProperties().add(index++, elementPropertyInfo);
            }
            classInfo.getProperties().remove(property);
        } else {
            this.logger.warn(MessageFormat.format("Element property [{0}] will not be simplified as it does not contain multiple types.", property.getName(false)));
        }
    }

    private void simplifyReferencePropertyInfoAsReferencePropertyInfo(Model model, CClassInfo classInfo, CReferencePropertyInfo property) {
        if (property.getElements().size() <= 1 && !property.isMixed()) {
            this.logger.warn(MessageFormat.format("Element reference property [{0}] will not be simplified as it does not contain multiple elements and is not mixed.", property.getName(false)));
        } else {
            this.logger.debug(MessageFormat.format("Element reference property [{0}] contains multiple elements or is mixed and will be simplified.", property.getName(false)));
            int index = classInfo.getProperties().indexOf(property);
            for (CElement element : property.getElements()) {
                CReferencePropertyInfo referencePropertyInfo = this.createReferencePropertyInfo(model, property, element);
                classInfo.getProperties().add(index++, referencePropertyInfo);
            }
            if (property.isMixed()) {
                classInfo.getProperties().add(index++, this.createContentReferencePropertyInfo(model, property));
            }
            classInfo.getProperties().remove(property);
        }
    }

    private void simplifyReferencePropertyInfoAsElementPropertyInfo(Model model, CClassInfo classInfo, CReferencePropertyInfo property) {
        if (property.getElements().size() <= 1 && !property.isMixed()) {
            this.logger.warn(MessageFormat.format("Element reference property [{0}] will not be simplified as it does not contain multiple elements and is not mixed.", property.getName(false)));
        } else {
            this.logger.debug(MessageFormat.format("Element reference property [{0}] contains multiple elements or is mixed and will be simplified.", property.getName(false)));
            int index = classInfo.getProperties().indexOf(property);
            for (CElement element : property.getElements()) {
                CElementPropertyInfo elementPropertyInfo;
                if (element instanceof CElementInfo) {
                    elementPropertyInfo = this.createElementPropertyInfo(model, property, element, (CElementInfo)element);
                } else if (element instanceof CClassInfo) {
                    elementPropertyInfo = this.createElementPropertyInfo(model, property, element, (CClassInfo)element);
                } else if (element instanceof CClassRef) {
                    this.logger.error(MessageFormat.format("Element reference property [{0}] contains a class reference type [{1}] and therefore cannot be fully simplified as element property.", property.getName(false), ((CClassRef)element).fullName()));
                    elementPropertyInfo = null;
                } else {
                    elementPropertyInfo = null;
                    this.logger.error(MessageFormat.format("Unsupported CElement type [{0}].", element));
                }
                if (elementPropertyInfo == null) continue;
                classInfo.getProperties().add(index++, elementPropertyInfo);
            }
            if (property.isMixed()) {
                classInfo.getProperties().add(index++, this.createContentReferencePropertyInfo(model, property));
            }
            classInfo.getProperties().remove(property);
        }
    }

    private CElementPropertyInfo createElementPropertyInfo(Model model, CReferencePropertyInfo property, CElement element, CElementInfo elementInfo) {
        String propertyName = this.createPropertyName(model, (CPropertyInfo)property, element);
        CElementPropertyInfo originalPropertyInfo = elementInfo.getProperty();
        CElementPropertyInfo elementPropertyInfo = new CElementPropertyInfo(propertyName, property.isCollection() ? CElementPropertyInfo.CollectionMode.REPEATED_ELEMENT : CElementPropertyInfo.CollectionMode.NOT_REPEATED, ID.NONE, null, element.getSchemaComponent(), element.getCustomizations(), element.getLocator(), false);
        CAdapter adapter = originalPropertyInfo.getAdapter();
        if (adapter != null) {
            elementPropertyInfo.setAdapter(adapter);
        }
        elementPropertyInfo.getTypes().add(new CTypeRef(elementInfo.getContentType(), element.getElementName(), elementInfo.getContentType().getTypeName(), false, null));
        return elementPropertyInfo;
    }

    private CElementPropertyInfo createElementPropertyInfo(Model model, CReferencePropertyInfo property, CElement element, CClassInfo classInfo) {
        String propertyName = this.createPropertyName(model, (CPropertyInfo)property, element);
        CElementPropertyInfo elementPropertyInfo = new CElementPropertyInfo(propertyName, property.isCollection() ? CElementPropertyInfo.CollectionMode.REPEATED_ELEMENT : CElementPropertyInfo.CollectionMode.NOT_REPEATED, ID.NONE, null, element.getSchemaComponent(), element.getCustomizations(), element.getLocator(), false);
        elementPropertyInfo.getTypes().add(new CTypeRef((CNonElement)classInfo, element.getElementName(), classInfo.getTypeName(), false, null));
        return elementPropertyInfo;
    }

    private CReferencePropertyInfo createReferencePropertyInfo(Model model, CReferencePropertyInfo property, CElement element) {
        String propertyName = this.createPropertyName(model, (CPropertyInfo)property, element);
        CReferencePropertyInfo referencePropertyInfo = new CReferencePropertyInfo(propertyName, property.isCollection(), false, false, element.getSchemaComponent(), element.getCustomizations(), element.getLocator(), property.isDummy(), property.isContent(), property.isMixedExtendedCust());
        referencePropertyInfo.getElements().add(element);
        return referencePropertyInfo;
    }

    private CReferencePropertyInfo createContentReferencePropertyInfo(Model model, CReferencePropertyInfo property) {
        String propertyName = "Mixed" + property.getName(true);
        CReferencePropertyInfo referencePropertyInfo = new CReferencePropertyInfo(propertyName, true, false, true, property.getSchemaComponent(), property.getCustomizations(), property.getLocator(), false, true, property.isMixedExtendedCust());
        return referencePropertyInfo;
    }

    private CElementPropertyInfo createElementPropertyInfo(Model model, CElementPropertyInfo property, CTypeRef typeRef) {
        String propertyName = this.createPropertyName(model, (CPropertyInfo)property, typeRef);
        boolean required = false;
        CElementPropertyInfo elementPropertyInfo = new CElementPropertyInfo(propertyName, property.isCollection() ? CElementPropertyInfo.CollectionMode.REPEATED_ELEMENT : CElementPropertyInfo.CollectionMode.NOT_REPEATED, typeRef.getTarget().idUse(), typeRef.getTarget().getExpectedMimeType(), property.getSchemaComponent(), property.getCustomizations(), property.getLocator(), required);
        CAdapter adapter = property.getAdapter();
        if (adapter != null) {
            elementPropertyInfo.setAdapter(adapter);
        }
        elementPropertyInfo.getTypes().add(typeRef);
        return elementPropertyInfo;
    }

    private String createPropertyName(Model model, CPropertyInfo propertyInfo, CElement element) {
        String localPart;
        if (element instanceof CClassRef) {
            CClassRef classRef = (CClassRef)element;
            String fullName = classRef.fullName();
            localPart = fullName.substring(fullName.lastIndexOf(46) + 1);
        } else {
            localPart = element.getElementName().getLocalPart();
        }
        String propertyName = model.getNameConverter().toPropertyName(this.pluralizeIfNecessary(propertyInfo, localPart));
        return propertyName;
    }

    private String createPropertyName(Model model, CPropertyInfo propertyInfo, CTypeRef element) {
        String propertyName = model.getNameConverter().toPropertyName(this.pluralizeIfNecessary(propertyInfo, element.getTagName().getLocalPart()));
        return propertyName;
    }

    private String pluralizeIfNecessary(CPropertyInfo propertyInfo, String propertyName) {
        return propertyInfo.isCollection() && this.isUsePluralForm() ? JJavaName.getPluralForm((String)propertyName) : propertyName;
    }
}

