/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.equals;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.lang.Equals;
import org.jvnet.basicjaxb.lang.EqualsStrategy;
import org.jvnet.basicjaxb.lang.JAXBEqualsStrategy;
import org.jvnet.basicjaxb.locator.DefaultRootObjectLocator;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.Customizations;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.util.FieldOutlineUtils;
import org.jvnet.basicjaxb.plugin.util.StrategyClassUtils;
import org.jvnet.basicjaxb.util.ClassUtils;
import org.jvnet.basicjaxb.util.FieldAccessorFactory;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.jvnet.basicjaxb.util.PropertyFieldAccessorFactory;
import org.jvnet.basicjaxb.xjc.outline.FieldAccessorEx;
import org.xml.sax.ErrorHandler;

public class EqualsPlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "Xequals";
    private static final String OPTION_DESC = "generate reflection-free 'equals' methods";
    private FieldAccessorFactory fieldAccessorFactory = PropertyFieldAccessorFactory.INSTANCE;
    private String equalsStrategyClass = JAXBEqualsStrategy.class.getName();
    private Ignoring ignoring = new CustomizedIgnoring(org.jvnet.basicjaxb.plugin.equals.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public FieldAccessorFactory getFieldAccessorFactory() {
        return this.fieldAccessorFactory;
    }

    public void setFieldAccessorFactory(FieldAccessorFactory fieldAccessorFactory) {
        this.fieldAccessorFactory = fieldAccessorFactory;
    }

    public String getEqualsStrategyClass() {
        return this.equalsStrategyClass;
    }

    public void setEqualsStrategyClass(String equalsStrategyClass) {
        this.equalsStrategyClass = equalsStrategyClass;
    }

    public JExpression createEqualsStrategy(JCodeModel codeModel) {
        return StrategyClassUtils.createStrategyInstanceExpression(codeModel, EqualsStrategy.class, this.getEqualsStrategyClass());
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(org.jvnet.basicjaxb.plugin.equals.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  EqualsStrategyClass.: " + this.getEqualsStrategyClass());
            sb.append("\n  Verbose.............: " + this.isVerbose());
            sb.append("\n  Debug...............: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (ClassOutline classOutline : outline.getClasses()) {
            if (this.getIgnoring().isIgnored(classOutline)) continue;
            this.processClassOutline(classOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processClassOutline(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        ClassUtils._implements((JDefinedClass)theClass, (JClass)theClass.owner().ref(Equals.class));
        JMethod equals = this.generateEquals$equals(classOutline, theClass);
        JMethod objectEquals = this.generateObject$equals(classOutline, theClass);
    }

    protected JMethod generateObject$equals(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod objectEquals = theClass.method(1, (JType)codeModel.BOOLEAN, "equals");
        objectEquals.annotate(Override.class);
        JVar that = objectEquals.param(Object.class, "object");
        JBlock body = objectEquals.body();
        JVar thisLocator = body.decl(0, (JType)codeModel.ref(ObjectLocator.class), "thisLocator", JExpr._null());
        JVar thatLocator = body.decl(0, (JType)codeModel.ref(ObjectLocator.class), "thatLocator", JExpr._null());
        JVar equalsStrategy = body.decl(8, (JType)codeModel.ref(EqualsStrategy.class), "strategy", this.createEqualsStrategy(codeModel));
        JInvocation thisRootLocator = JExpr._new((JClass)codeModel.ref(DefaultRootObjectLocator.class)).arg(JExpr._this());
        JInvocation thatRootLocator = JExpr._new((JClass)codeModel.ref(DefaultRootObjectLocator.class)).arg((JExpression)that);
        JConditional ifDebugEnabled = body._if((JExpression)equalsStrategy.invoke("isDebugEnabled"));
        ifDebugEnabled._then().assign((JAssignmentTarget)thisLocator, (JExpression)thisRootLocator).assign((JAssignmentTarget)thatLocator, (JExpression)thatRootLocator);
        body._return((JExpression)JExpr.invoke((String)"equals").arg((JExpression)thisLocator).arg((JExpression)thatLocator).arg((JExpression)that).arg((JExpression)equalsStrategy));
        this.debug("{}, generateObject$equals; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
        return objectEquals;
    }

    protected JMethod generateEquals$equals(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod equals = theClass.method(1, (JType)codeModel.BOOLEAN, "equals");
        equals.annotate(Override.class);
        JBlock body = equals.body();
        JVar lhsLocator = equals.param(ObjectLocator.class, "thisLocator");
        JVar rhsLocator = equals.param(ObjectLocator.class, "thatLocator");
        JVar object = equals.param(Object.class, "object");
        JVar equalsStrategy = equals.param(EqualsStrategy.class, "strategy");
        JExpression objectIsNull = object.eq(JExpr._null());
        JExpression notTheSameType = JExpr._this().invoke("getClass").ne((JExpression)object.invoke("getClass"));
        body._if(JOp.cor((JExpression)objectIsNull, (JExpression)notTheSameType))._then()._return(JExpr.FALSE);
        body._if(JExpr._this().eq((JExpression)object))._then()._return(JExpr.TRUE);
        Boolean superClassImplementsEquals = StrategyClassUtils.superClassImplements(classOutline, this.getIgnoring(), Equals.class);
        if (superClassImplementsEquals != null) {
            if (superClassImplementsEquals.booleanValue()) {
                body._if(JOp.not((JExpression)JExpr._super().invoke("equals").arg((JExpression)lhsLocator).arg((JExpression)rhsLocator).arg((JExpression)object).arg((JExpression)equalsStrategy)))._then()._return(JExpr.FALSE);
            } else {
                body._if(JOp.not((JExpression)JExpr._super().invoke("equals").arg((JExpression)object)))._then()._return(JExpr.FALSE);
            }
        }
        JExpression _this = JExpr._this();
        FieldOutline[] declaredFields = FieldOutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring());
        if (declaredFields.length > 0) {
            JVar _that = body.decl(8, (JType)theClass, "that", (JExpression)JExpr.cast((JType)theClass, (JExpression)object));
            for (FieldOutline fieldOutline : declaredFields) {
                FieldAccessorEx lhsFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, _this);
                FieldAccessorEx rhsFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, (JExpression)_that);
                if (lhsFieldAccessor.isConstant() || rhsFieldAccessor.isConstant()) continue;
                JBlock block = body.block();
                JExpression lhsFieldHasSetValueEx = lhsFieldAccessor.isAlwaysSet() || lhsFieldAccessor.hasSetValue() == null ? JExpr.TRUE : lhsFieldAccessor.hasSetValue();
                JExpression rhsFieldHasSetValueEx = rhsFieldAccessor.isAlwaysSet() || rhsFieldAccessor.hasSetValue() == null ? JExpr.TRUE : rhsFieldAccessor.hasSetValue();
                JVar lhsFieldIsSet = block.decl(codeModel.ref(Boolean.class).unboxify(), "lhsFieldIsSet", lhsFieldHasSetValueEx);
                JVar rhsFieldIsSet = block.decl(codeModel.ref(Boolean.class).unboxify(), "rhsFieldIsSet", rhsFieldHasSetValueEx);
                JVar lhsValue = block.decl(lhsFieldAccessor.getType(), this.fieldName("lhs"));
                lhsFieldAccessor.toRawValue(block, lhsValue);
                JVar rhsValue = block.decl(rhsFieldAccessor.getType(), this.fieldName("rhs"));
                rhsFieldAccessor.toRawValue(block, rhsValue);
                String fieldName = this.fieldName(fieldOutline);
                JInvocation lhsFieldLocatorEx = codeModel.ref(org.jvnet.basicjaxb.locator.util.LocatorUtils.class).staticInvoke("property").arg((JExpression)lhsLocator).arg(fieldName).arg((JExpression)lhsValue);
                JInvocation rhsFieldLocatorEx = codeModel.ref(org.jvnet.basicjaxb.locator.util.LocatorUtils.class).staticInvoke("property").arg((JExpression)rhsLocator).arg(fieldName).arg((JExpression)rhsValue);
                JVar lhsFieldLocator = block.decl(lhsLocator.type(), "lhsFieldLocator", (JExpression)lhsFieldLocatorEx);
                JVar rhsFieldLocator = block.decl(lhsLocator.type(), "rhsFieldLocator", (JExpression)rhsFieldLocatorEx);
                block._if(JOp.not((JExpression)JExpr.invoke((JExpression)equalsStrategy, (String)"equals").arg((JExpression)lhsFieldLocator).arg((JExpression)rhsFieldLocator).arg((JExpression)lhsValue).arg((JExpression)rhsValue).arg((JExpression)lhsFieldIsSet).arg((JExpression)rhsFieldIsSet)))._then()._return(JExpr.FALSE);
                this.trace("{}, generateEquals$equals; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Object)fieldOutline.getPropertyInfo().getLocator()), theClass.name(), fieldName});
            }
        }
        body._return(JExpr.TRUE);
        return equals;
    }

    private String fieldName(FieldOutline fieldOutline) {
        return fieldOutline.getPropertyInfo().getName(false);
    }

    private String fieldName(String prefix) {
        return prefix + "Field";
    }

    private String fieldName(String prefix, FieldOutline fieldOutline) {
        return this.fieldName(prefix) + fieldOutline.getPropertyInfo().getName(true);
    }
}

