/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.setters;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldAccessor;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.setters.Customizations;
import org.jvnet.basicjaxb.plugin.util.FieldOutlineUtils;
import org.jvnet.basicjaxb.util.CodeModelUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.xml.sax.ErrorHandler;

public class SettersPlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "Xsetters";
    private static final String OPTION_DESC = "generate setters for collections";
    private Ignoring ignoring = new CustomizedIgnoring(Customizations.IGNORED_ELEMENT_NAME);
    private Mode mode = Mode.accessor;
    private static final JType[] ABSENT = new JType[0];

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.IGNORED_ELEMENT_NAME);
    }

    public String getMode() {
        return this.mode.name();
    }

    public void setMode(String mode) {
        Objects.requireNonNull(mode);
        try {
            this.mode = Mode.valueOf(mode);
        }
        catch (IllegalArgumentException iaex) {
            throw new IllegalArgumentException("Unsupported mode [" + mode + "]. Supported modes are [accessor] (uses JAXB-generated accessors, default) and [direct] (assigns the value list to the field directly).");
        }
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Mode....: " + this.getMode());
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (ClassOutline classOutline : outline.getClasses()) {
            if (this.getIgnoring().isIgnored(classOutline)) continue;
            this.processClassOutline(classOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processClassOutline(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        this.generateSetters(classOutline, theClass);
    }

    private void generateSetters(ClassOutline classOutline, JDefinedClass theClass) {
        FieldOutline[] declaredFields;
        boolean addedSetter = false;
        for (FieldOutline fieldOutline : declaredFields = FieldOutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring())) {
            JMethod setter;
            CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
            String publicName = fieldInfo.getName(true);
            String getterName = "get" + publicName;
            JMethod getter = theClass.getMethod(getterName, ABSENT);
            if (getter == null) continue;
            JType type = getter.type();
            JType rawType = fieldOutline.getRawType();
            String setterName = "set" + publicName;
            JMethod boxifiedSetter = theClass.getMethod(setterName, new JType[]{rawType.boxify()});
            JMethod unboxifiedSetter = theClass.getMethod(setterName, new JType[]{rawType.unboxify()});
            JMethod jMethod = setter = boxifiedSetter != null ? boxifiedSetter : unboxifiedSetter;
            if (setter != null) continue;
            JMethod generatedSetter = theClass.method(1, (JType)theClass.owner().VOID, setterName);
            JVar value = generatedSetter.param(type, "value");
            this.mode.generateSetter(fieldOutline, theClass, generatedSetter, value);
            CodeModelUtils.groupMethods((JDefinedClass)theClass, (JMethod)getter, (JMethod)generatedSetter);
            addedSetter = true;
            this.trace("{}, generateSetters; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Object)fieldInfo.getLocator()), theClass.name(), fieldInfo.getName(false)});
        }
        if (addedSetter) {
            this.debug("{}, generateSetters; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
        }
    }

    public static enum Mode {
        accessor{

            @Override
            public void generateSetter(FieldOutline fieldOutline, JDefinedClass theClass, JMethod setter, JVar value) {
                FieldAccessor accessor = fieldOutline.create(JExpr._this());
                accessor.unsetValues(setter.body());
                accessor.fromRawValue(setter.body()._if(value.ne(JExpr._null()))._then(), "draftRol", (JExpression)value);
            }
        }
        ,
        direct{

            @Override
            public void generateSetter(FieldOutline fieldOutline, JDefinedClass theClass, JMethod setter, JVar value) {
                JFieldVar field = (JFieldVar)theClass.fields().get(fieldOutline.getPropertyInfo().getName(false));
                if (field != null) {
                    setter.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)field), (JExpression)value);
                } else {
                    accessor.generateSetter(fieldOutline, theClass, setter, value);
                }
            }
        };


        public abstract void generateSetter(FieldOutline var1, JDefinedClass var2, JMethod var3, JVar var4);
    }
}

