/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.wildcard;

import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.Model;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.glassfish.jaxb.core.v2.model.core.WildcardMode;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.wildcard.Customizations;
import org.jvnet.basicjaxb.util.CustomizationUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.xml.sax.ErrorHandler;

public class WildcardPlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "Xwildcard";
    private static final String OPTION_DESC = "specify the wildcard mode for wildcard properties";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    protected void beforePostProcessModel(Model model) {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterPostProcessModel(Model model, ErrorHandler errorHandler) {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError(errorHandler));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public void postProcessModel(Model model) {
        boolean laxModel = CustomizationUtils.containsCustomization((Model)model, (QName)Customizations.LAX_ELEMENT_NAME);
        boolean skipModel = CustomizationUtils.containsCustomization((Model)model, (QName)Customizations.SKIP_ELEMENT_NAME);
        boolean strictModel = CustomizationUtils.containsCustomization((Model)model, (QName)Customizations.STRICT_ELEMENT_NAME);
        for (CClassInfo classInfo : model.beans().values()) {
            boolean laxClassInfo = CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.LAX_ELEMENT_NAME);
            boolean skipClassInfo = CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.SKIP_ELEMENT_NAME);
            boolean strictClassInfo = CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.STRICT_ELEMENT_NAME);
            for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
                if (!(propertyInfo instanceof CReferencePropertyInfo)) continue;
                CReferencePropertyInfo referencePropertyInfo = (CReferencePropertyInfo)propertyInfo;
                boolean laxPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, (QName)Customizations.LAX_ELEMENT_NAME);
                boolean skipPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, (QName)Customizations.SKIP_ELEMENT_NAME);
                boolean strictPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, (QName)Customizations.STRICT_ELEMENT_NAME);
                if (laxModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                } else if (skipModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                } else if (strictModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.STRICT);
                }
                if (laxClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                } else if (skipClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                } else if (strictClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.STRICT);
                }
                if (laxPropertyInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                } else if (skipPropertyInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                } else if (strictPropertyInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.STRICT);
                }
                this.trace("{}, postProcessModel; Class={}, Property={}, Wildcard={}", new Object[]{LocatorUtils.toLocation((Object)propertyInfo.getLocator()), classInfo.shortName, propertyInfo.getName(false), referencePropertyInfo.getWildcard()});
            }
            this.debug("{}, postProcessModel; Class={}", new Object[]{LocatorUtils.toLocation((Object)classInfo.getLocator()), classInfo.shortName});
        }
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.LAX_ELEMENT_NAME, Customizations.SKIP_ELEMENT_NAME, Customizations.STRICT_ELEMENT_NAME);
    }
}

