/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import java.util.Collection;
import org.jvnet.basicjaxb.lang.Equals;
import org.jvnet.basicjaxb.lang.Equals2;
import org.jvnet.basicjaxb.lang.EqualsStrategy;
import org.jvnet.basicjaxb.lang.EqualsStrategy2;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.locator.util.LocatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEqualsStrategy
implements EqualsStrategy2,
EqualsStrategy {
    protected Logger logger = LoggerFactory.getLogger(DefaultEqualsStrategy.class);
    public static DefaultEqualsStrategy INSTANCE2 = new DefaultEqualsStrategy();
    public static EqualsStrategy INSTANCE = INSTANCE2;

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String message) {
        this.logger.trace(message);
    }

    private void traceNotEqual(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object lhs, Object rhs) {
        if (this.isTraceEnabled()) {
            this.trace("Objects are NOT equal!");
            this.traceNotEqual("LHS", lhsLocator, lhs);
            this.traceNotEqual("RHS", rhsLocator, rhs);
        }
    }

    private void traceNotEqual(String label, ObjectLocator locator, Object obj) {
        String value = "null";
        String message = "";
        if (obj != null) {
            value = obj instanceof Collection ? obj.getClass().getName() + "[" + ((Collection)obj).size() + "]" : (obj != null && obj.getClass().isArray() ? obj.getClass().getName() + "[" + ((Object[])obj).length + "]" : obj.toString());
        }
        message = locator != null ? label + ": {" + locator.getPathAsString() + "} -> " + value : label + ": {} -> " + value;
        this.trace(message);
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, Object lhs, Object rhs) {
        if (this.equalsObject(leftLocator, rightLocator, lhs, rhs)) {
            return true;
        }
        this.traceNotEqual(leftLocator, rightLocator, lhs, rhs);
        return false;
    }

    protected boolean equalsObject(ObjectLocator leftLocator, ObjectLocator rightLocator, Object lhs, Object rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        Class<?> lhsClass = lhs.getClass();
        if (!lhsClass.isArray()) {
            return this.equalsInternal(leftLocator, rightLocator, lhs, rhs);
        }
        if (lhs.getClass() != rhs.getClass()) {
            return false;
        }
        if (lhs instanceof long[]) {
            return this.equals(leftLocator, rightLocator, (long[])lhs, (long[])rhs);
        }
        if (lhs instanceof int[]) {
            return this.equals(leftLocator, rightLocator, (int[])lhs, (int[])rhs);
        }
        if (lhs instanceof short[]) {
            return this.equals(leftLocator, rightLocator, (short[])lhs, (short[])rhs);
        }
        if (lhs instanceof char[]) {
            return this.equals(leftLocator, rightLocator, (char[])lhs, (char[])rhs);
        }
        if (lhs instanceof byte[]) {
            return this.equals(leftLocator, rightLocator, (byte[])lhs, (byte[])rhs);
        }
        if (lhs instanceof double[]) {
            return this.equals(leftLocator, rightLocator, (double[])lhs, (double[])rhs);
        }
        if (lhs instanceof float[]) {
            return this.equals(leftLocator, rightLocator, (float[])lhs, (float[])rhs);
        }
        if (lhs instanceof boolean[]) {
            return this.equals(leftLocator, rightLocator, (boolean[])lhs, (boolean[])rhs);
        }
        if (lhs instanceof Equals2[]) {
            return this.equalsInternal(leftLocator, rightLocator, (Equals2[])lhs, (Equals2[])rhs);
        }
        if (lhs instanceof Equals[]) {
            return this.equalsInternal(leftLocator, rightLocator, (Equals[])lhs, (Equals[])rhs);
        }
        if (lhs instanceof Enum[]) {
            return this.equalsInternal(leftLocator, rightLocator, (Enum[])lhs, (Enum[])rhs);
        }
        return this.equals(leftLocator, rightLocator, (Object[])lhs, (Object[])rhs);
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, Object lhs, Object rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs instanceof Equals2 && rhs instanceof Equals2) {
            return this.equalsInternal(leftLocator, rightLocator, (Equals2)lhs, (Equals2)rhs);
        }
        if (lhs instanceof Equals && rhs instanceof Equals) {
            return this.equalsInternal(leftLocator, rightLocator, (Equals)lhs, (Equals)rhs);
        }
        if (lhs instanceof Enum && rhs instanceof Enum) {
            return this.equalsInternal(leftLocator, rightLocator, (Enum)lhs, (Enum)rhs);
        }
        return lhs.equals(rhs);
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, Enum<?> lhs, Enum<?> rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs instanceof Equals2 && rhs instanceof Equals2) {
            return this.equalsInternal(leftLocator, rightLocator, (Equals2)((Object)lhs), (Equals2)((Object)rhs));
        }
        if (lhs instanceof Equals && rhs instanceof Equals) {
            return this.equalsInternal(leftLocator, rightLocator, (Equals)((Object)lhs), (Equals)((Object)rhs));
        }
        return lhs.equals(rhs);
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, Equals2 lhs, Equals2 rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        return lhs.equals(leftLocator, rightLocator, rhs, this);
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, Equals lhs, Equals rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        return lhs.equals(leftLocator, rightLocator, rhs, this);
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, boolean left, boolean right) {
        if (left == right) {
            return true;
        }
        this.traceNotEqual(leftLocator, rightLocator, left, right);
        return false;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, byte left, byte right) {
        if (left == right) {
            return true;
        }
        this.traceNotEqual(leftLocator, rightLocator, left, right);
        return false;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, char left, char right) {
        if (left == right) {
            return true;
        }
        this.traceNotEqual(leftLocator, rightLocator, Character.valueOf(left), Character.valueOf(right));
        return false;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, double left, double right) {
        return this.equals(leftLocator, rightLocator, Double.doubleToLongBits(left), Double.doubleToLongBits(right));
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, float left, float right) {
        return this.equals(leftLocator, rightLocator, Float.floatToIntBits(left), Float.floatToIntBits(right));
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, long left, long right) {
        if (left == right) {
            return true;
        }
        this.traceNotEqual(leftLocator, rightLocator, left, right);
        return false;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, int left, int right) {
        if (left == right) {
            return true;
        }
        this.traceNotEqual(leftLocator, rightLocator, left, right);
        return false;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, short left, short right) {
        if (left == right) {
            return true;
        }
        this.traceNotEqual(leftLocator, rightLocator, left, right);
        return false;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, Object[] left, Object[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(leftLocator, i, left[i]), (ObjectLocator)LocatorUtils.item(rightLocator, i, right[i]), left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, Equals2[] left, Equals2[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (this.equalsInternal((ObjectLocator)LocatorUtils.item(leftLocator, i, left[i]), (ObjectLocator)LocatorUtils.item(rightLocator, i, right[i]), left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, Equals[] left, Equals[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (this.equalsInternal((ObjectLocator)LocatorUtils.item(leftLocator, i, left[i]), (ObjectLocator)LocatorUtils.item(rightLocator, i, right[i]), left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean equalsInternal(ObjectLocator leftLocator, ObjectLocator rightLocator, Enum<?>[] left, Enum<?>[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (this.equalsInternal((ObjectLocator)LocatorUtils.item(leftLocator, i, left[i]), (ObjectLocator)LocatorUtils.item(rightLocator, i, right[i]), left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, boolean[] left, boolean[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(leftLocator, i, left[i]), (ObjectLocator)LocatorUtils.item(rightLocator, i, right[i]), left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, byte[] left, byte[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(leftLocator, i, left[i]), (ObjectLocator)LocatorUtils.item(rightLocator, i, right[i]), left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, char[] left, char[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(leftLocator, i, left[i]), (ObjectLocator)LocatorUtils.item(rightLocator, i, right[i]), left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, double[] left, double[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(leftLocator, i, left[i]), (ObjectLocator)LocatorUtils.item(rightLocator, i, right[i]), left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, float[] left, float[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(leftLocator, i, left[i]), (ObjectLocator)LocatorUtils.item(rightLocator, i, right[i]), left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, long[] left, long[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(leftLocator, i, left[i]), (ObjectLocator)LocatorUtils.item(rightLocator, i, right[i]), left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, int[] left, int[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(leftLocator, i, left[i]), (ObjectLocator)LocatorUtils.item(rightLocator, i, right[i]), left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, short[] left, short[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (this.equals((ObjectLocator)LocatorUtils.item(leftLocator, i, left[i]), (ObjectLocator)LocatorUtils.item(rightLocator, i, right[i]), left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, boolean left, boolean right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : this.equals((ObjectLocator)LocatorUtils.property(leftLocator, "isSet", leftSet), (ObjectLocator)LocatorUtils.property(rightLocator, "isSet", rightSet), leftSet, rightSet);
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, byte left, byte right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : this.equals((ObjectLocator)LocatorUtils.property(leftLocator, "isSet", leftSet), (ObjectLocator)LocatorUtils.property(rightLocator, "isSet", rightSet), leftSet, rightSet);
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, char left, char right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : this.equals((ObjectLocator)LocatorUtils.property(leftLocator, "isSet", leftSet), (ObjectLocator)LocatorUtils.property(rightLocator, "isSet", rightSet), leftSet, rightSet);
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, double left, double right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : this.equals((ObjectLocator)LocatorUtils.property(leftLocator, "isSet", leftSet), (ObjectLocator)LocatorUtils.property(rightLocator, "isSet", rightSet), leftSet, rightSet);
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, float left, float right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : this.equals((ObjectLocator)LocatorUtils.property(leftLocator, "isSet", leftSet), (ObjectLocator)LocatorUtils.property(rightLocator, "isSet", rightSet), leftSet, rightSet);
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, int left, int right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : this.equals((ObjectLocator)LocatorUtils.property(leftLocator, "isSet", leftSet), (ObjectLocator)LocatorUtils.property(rightLocator, "isSet", rightSet), leftSet, rightSet);
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, long left, long right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : this.equals((ObjectLocator)LocatorUtils.property(leftLocator, "isSet", leftSet), (ObjectLocator)LocatorUtils.property(rightLocator, "isSet", rightSet), leftSet, rightSet);
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, short left, short right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : this.equals((ObjectLocator)LocatorUtils.property(leftLocator, "isSet", leftSet), (ObjectLocator)LocatorUtils.property(rightLocator, "isSet", rightSet), leftSet, rightSet);
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : this.equals((ObjectLocator)LocatorUtils.property(leftLocator, "isSet", leftSet), (ObjectLocator)LocatorUtils.property(rightLocator, "isSet", rightSet), leftSet, rightSet);
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, boolean[] left, boolean[] right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : leftSet == rightSet;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, byte[] left, byte[] right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : leftSet == rightSet;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, char[] left, char[] right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : leftSet == rightSet;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, double[] left, double[] right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : leftSet == rightSet;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, float[] left, float[] right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : leftSet == rightSet;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, int[] left, int[] right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : leftSet == rightSet;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, long[] left, long[] right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : leftSet == rightSet;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, short[] left, short[] right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : leftSet == rightSet;
    }

    @Override
    public boolean equals(ObjectLocator leftLocator, ObjectLocator rightLocator, Object[] left, Object[] right, boolean leftSet, boolean rightSet) {
        return leftSet && rightSet ? this.equals(leftLocator, rightLocator, left, right) : leftSet == rightSet;
    }

    public static DefaultEqualsStrategy getInstance() {
        return INSTANCE2;
    }
}

