/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.basicjaxb.lang.CopyStrategy;
import org.jvnet.basicjaxb.lang.DefaultCopyStrategy;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.locator.util.LocatorUtils;
import org.w3c.dom.Node;

public class JAXBCopyStrategy
extends DefaultCopyStrategy {
    public static final JAXBCopyStrategy INSTANCE2 = new JAXBCopyStrategy();
    public static final CopyStrategy INSTANCE = INSTANCE2;

    @Override
    protected Object copyInternal(ObjectLocator locator, Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            return this.copyInternal(locator, node);
        }
        if (object instanceof JAXBElement) {
            JAXBElement jaxbElement = (JAXBElement)object;
            return this.copyInternal(locator, jaxbElement);
        }
        if (object instanceof List) {
            List list = (List)object;
            return this.copyInternal(locator, list);
        }
        return super.copyInternal(locator, object);
    }

    protected Object copyInternal(ObjectLocator locator, Node node) {
        return node.cloneNode(true);
    }

    protected Object copyInternal(ObjectLocator locator, JAXBElement jaxbElement) {
        Object sourceObject = jaxbElement.getValue();
        Object copyObject = this.copy((ObjectLocator)LocatorUtils.property(locator, "value", sourceObject), sourceObject);
        JAXBElement copyElement = new JAXBElement(jaxbElement.getName(), jaxbElement.getDeclaredType(), jaxbElement.getScope(), copyObject);
        return copyElement;
    }

    protected Object copyInternal(ObjectLocator locator, List list) {
        ArrayList<Object> copy = new ArrayList<Object>(list.size());
        for (int index = 0; index < list.size(); ++index) {
            Object element = list.get(index);
            Object copyElement = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
            copy.add(copyElement);
        }
        return copy;
    }

    public static JAXBCopyStrategy getInstance() {
        return INSTANCE2;
    }
}

