/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.xml.bind.model.util;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.lang.StringUtils;
import org.jvnet.basicjaxb.lang.Validate;
import org.jvnet.basicjaxb.xml.bind.model.MClassInfo;
import org.jvnet.basicjaxb.xml.bind.model.MElementInfo;
import org.jvnet.basicjaxb.xml.bind.model.MModelInfo;
import org.jvnet.basicjaxb.xml.bind.model.MPackageInfo;
import org.jvnet.basicjaxb.xml.bind.model.MPropertyInfo;
import org.jvnet.basicjaxb.xml.bind.model.util.QNameCollectingPropertyInfoVisitor;
import org.jvnet.basicjaxb.xml.bind.model.util.QNameCollector;

public class PackageInfoQNameAnalyzer<T, C extends T> {
    private final MModelInfo<T, C> modelInfo;

    public PackageInfoQNameAnalyzer(MModelInfo<T, C> modelInfo) {
        Validate.notNull(modelInfo);
        this.modelInfo = modelInfo;
    }

    public String getMostUsedElementNamespaceURI(MPackageInfo packageInfo) {
        final NamespaceURICounter counter = new NamespaceURICounter();
        QNameCollector collector = new QNameCollector(){

            @Override
            public void element(QName name) {
                counter.add(name.getNamespaceURI());
            }

            @Override
            public void attribute(QName name) {
            }
        };
        this.collectNamespaceURIs(packageInfo, collector);
        return counter.getMostUsedNamespaceURI();
    }

    public String getMostUsedAttributeNamespaceURI(MPackageInfo packageInfo) {
        final NamespaceURICounter counter = new NamespaceURICounter();
        QNameCollector collector = new QNameCollector(){

            @Override
            public void element(QName name) {
            }

            @Override
            public void attribute(QName name) {
                counter.add(name.getNamespaceURI());
            }
        };
        this.collectNamespaceURIs(packageInfo, collector);
        return counter.getMostUsedNamespaceURI();
    }

    private void collectNamespaceURIs(MPackageInfo packageInfo, QNameCollector collector) {
        for (MElementInfo<T, C> elementInfo : this.modelInfo.getElementInfos()) {
            if (elementInfo.getPackageInfo() != packageInfo) continue;
            collector.element(elementInfo.getElementName());
        }
        QNameCollectingPropertyInfoVisitor visitor = new QNameCollectingPropertyInfoVisitor(collector);
        for (MClassInfo<T, C> classInfo : this.modelInfo.getClassInfos()) {
            if (classInfo.getPackageInfo() != packageInfo) continue;
            for (MPropertyInfo<T, C> propertyInfo : classInfo.getProperties()) {
                propertyInfo.acceptPropertyInfoVisitor(visitor);
            }
        }
    }

    private static class NamespaceURICounter {
        private Map<String, Integer> map = new HashMap<String, Integer>();

        private NamespaceURICounter() {
        }

        public void add(String namespaceURI) {
            Integer count = this.map.get(namespaceURI);
            if (count == null) {
                this.map.put(namespaceURI, 1);
            } else {
                this.map.put(namespaceURI, count + 1);
            }
        }

        public String getMostUsedNamespaceURI() {
            String namespaceURI = null;
            int count = 0;
            for (Map.Entry<String, Integer> e : this.map.entrySet()) {
                String currentNamespaceURI = e.getKey();
                int currentCount = e.getValue();
                if (namespaceURI == null) {
                    namespaceURI = currentNamespaceURI;
                    count = currentCount;
                    continue;
                }
                if (currentCount <= count && (currentCount != count || namespaceURI != null)) continue;
                namespaceURI = currentNamespaceURI;
                count = currentCount;
            }
            return StringUtils.isEmpty(namespaceURI) ? null : namespaceURI;
        }
    }
}

