/*
 * Decompiled with CFR 0.152.
 */
package org.patrodyne.jvnet.basicjaxb.explore;

import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import org.patrodyne.jvnet.basicjaxb.explore.ContextMenuListener;
import org.patrodyne.jvnet.basicjaxb.explore.SelectAllAction;

public class ConsoleReader
extends Reader {
    private PipedWriter pipedWriter;
    private PipedReader pipedReader;
    private JTextArea textArea;

    public PipedWriter getPipedWriter() {
        return this.pipedWriter;
    }

    public void setPipedWriter(PipedWriter pipedWriter) {
        this.pipedWriter = pipedWriter;
    }

    public PipedReader getPipedReader() {
        return this.pipedReader;
    }

    public void setPipedReader(PipedReader pipedReader) {
        this.pipedReader = pipedReader;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public ConsoleReader(int points) throws IOException {
        this.setPipedWriter(new PipedWriter());
        this.setPipedReader(new PipedReader(this.getPipedWriter()));
        this.getPipedWriter().connect(this.getPipedReader());
        this.textArea = new JTextArea();
        this.textArea.setEditable(true);
        this.textArea.setFont(new Font("monospaced", 0, points));
        this.textArea.setTabSize(4);
        this.textArea.addMouseListener(this.createContextMenuListener());
        this.textArea.addKeyListener(this.createKeyListener());
    }

    private KeyListener createKeyListener() {
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyReleased(KeyEvent ke) {
                if (10 == ke.getKeyCode()) {
                    JTextArea source = (JTextArea)ke.getSource();
                    int caretPosition = source.getCaretPosition();
                    String line = source.getText().substring(0, caretPosition);
                    try {
                        ConsoleReader.this.getPipedWriter().write(line);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent ke) {
            }

            @Override
            public void keyTyped(KeyEvent ke) {
            }
        };
        return keyListener;
    }

    private MouseListener createContextMenuListener() {
        JPopupMenu contextMenu = new JPopupMenu();
        contextMenu.add(new JMenuItem(new DefaultEditorKit.CopyAction()));
        contextMenu.add(new JMenuItem(new SelectAllAction()));
        return new ContextMenuListener(contextMenu);
    }

    public void largerText() {
        Font curFont = this.getTextArea().getFont();
        if (curFont.getSize() < 32) {
            this.getTextArea().setFont(curFont.deriveFont((float)curFont.getSize() + 1.0f));
        }
    }

    public void smallerText() {
        Font curFont = this.getTextArea().getFont();
        if (curFont.getSize() > 8) {
            this.getTextArea().setFont(curFont.deriveFont((float)curFont.getSize() - 1.0f));
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.getPipedReader().read(cbuf, off, len);
    }

    public void clear() {
        try {
            int length = this.getTextArea().getDocument().getLength();
            this.getTextArea().getDocument().remove(0, length);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        this.getPipedReader().close();
        this.getPipedWriter().close();
    }
}

