/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.lang.reflect.Modifier;
import org.pkl.core.util.Nullable;

public final class TypeMapping<S, T extends S> {
    public final Class<S> requestedType;
    public final Class<T> implementationType;

    private TypeMapping(Class<S> requestedType, Class<T> implementationType) {
        if (Modifier.isAbstract(implementationType.getModifiers())) {
            throw new IllegalArgumentException(String.format("`implementationType` must not be abstract, but `%s` is.", implementationType.getTypeName()));
        }
        if (!requestedType.isAssignableFrom(implementationType)) {
            throw new IllegalArgumentException(String.format("`implementationType` must be assignable to `requestedType`, but `%s` is not assignable to `%s`.", implementationType.getTypeName(), requestedType.getTypeName()));
        }
        if (requestedType.isArray() || implementationType.isArray()) {
            throw new IllegalArgumentException("Type mappings are not supported for array types.");
        }
        this.requestedType = requestedType;
        this.implementationType = implementationType;
    }

    public static <S, T extends S> TypeMapping<S, T> of(Class<S> requestedType, Class<T> implementationType) {
        return new TypeMapping<S, T>(requestedType, implementationType);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeMapping)) {
            return false;
        }
        TypeMapping other = (TypeMapping)obj;
        return this.requestedType == other.requestedType && this.implementationType == other.implementationType;
    }

    public int hashCode() {
        return this.requestedType.hashCode() * 31 + this.implementationType.hashCode();
    }

    public String toString() {
        return String.format("TypeMapping(%s, %s)", this.requestedType.getTypeName(), this.implementationType.getTypeName());
    }
}

